/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.shapefile;

import gov.nasa.giss.map.shapefile.ShapeException;
import gov.nasa.giss.map.shapefile.ShapeRecordType;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import java.util.Objects;

final class ShapeUtils {
    private ShapeUtils() {
    }

    static byte[] arraySection(byte[] bb, int start, int length) {
        byte[] bbx = new byte[length];
        for (int i = 0; i < length; ++i) {
            bbx[i] = bb[start + i];
        }
        return bbx;
    }

    static byte[] flipBytes(byte[] bb) {
        byte[] bbx = new byte[bb.length];
        for (int i = 0; i < bb.length; ++i) {
            bbx[i] = bb[bb.length - 1 - i];
        }
        return bbx;
    }

    static int intFromBigBytes(byte[] bb) {
        Objects.requireNonNull(bb, "Input bytes cannot be null.");
        if (bb.length != 4) {
            throw new ShapeException("Wrong count of input bytes.");
        }
        return ByteBuffer.wrap(bb).getInt();
    }

    static int intFromLittleBytes(byte[] bb) {
        return ShapeUtils.intFromBigBytes(ShapeUtils.flipBytes(bb));
    }

    static double doubleFromLittleBytes(byte[] bb) {
        Objects.requireNonNull(bb, "Input bytes cannot be null.");
        if (bb.length != 8) {
            throw new IllegalArgumentException("Wrong count of input bytes.");
        }
        return ByteBuffer.wrap(ShapeUtils.flipBytes(bb)).getDouble();
    }

    static ShapeRecordType shapeTypeFromBytes(byte[] buffer, int offset) {
        int shapeID = ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(buffer, offset, 4));
        return ShapeRecordType.matching(shapeID);
    }

    static int[] intsFromLittleBytes(byte[] buffer, int offset, int numPoints) {
        int[] ii = new int[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            ii[i] = ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(buffer, offset + i * 4, 4));
        }
        return ii;
    }

    static double[] doublesFromLittleBytes(byte[] buffer, int offset, int numPoints) {
        double[] dd = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            dd[i] = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, offset + i * 8, 8));
        }
        return dd;
    }

    static Point2D.Double[] pointsFromLittleBytes(byte[] buffer, int offset, int numPoints) {
        Point2D.Double[] pts = new Point2D.Double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            double x = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, offset + i * 2 * 8, 8));
            double y = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, offset + 8 + i * 2 * 8, 8));
            pts[i] = new Point2D.Double(x, y);
        }
        return pts;
    }
}

