/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotUnifiedPseudoPalette;
import gov.nasa.giss.panoply.plotui.PanPlotWindoid;
import gov.nasa.giss.panoply.plotui.PanPlotWindoidUnified;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanChangePlotControlsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame parent_;
    private final boolean next_;

    public PanChangePlotControlsAction(PanPlotFrame parent, String actionName, boolean next) {
        super(actionName);
        this.parent_ = parent;
        this.next_ = next;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (PanPlotControlsMeta.isFloating()) {
            PanPlotWindoid ww = this.parent_.getControlsWindoid(PanPlotControlsID.UNIFIED);
            if (ww == null) {
                LOGGER.trace("Unified controls windoid is null.");
                return;
            }
            PanPlotWindoidUnified wwu = (PanPlotWindoidUnified)ww;
            if (this.next_) {
                wwu.next();
            } else {
                wwu.previous();
            }
        } else {
            PanPlotUnifiedPseudoPalette upp = this.parent_.getPseudoPalette();
            if (upp == null) {
                LOGGER.trace("Pseudo controls palette is null.");
                return;
            }
            if (this.next_) {
                upp.next();
            } else {
                upp.previous();
            }
        }
    }
}

