/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.plaf;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.ui.plaf.MultiLineLabelUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class EmphasizedMultiLineLabelUI
extends MultiLineLabelUI {
    private static final Color ENABLED_BACKGROUND_COLOR = new Color(255, 255, 255, 110);
    private static final Color ENABLED_FOREGROUND_COLOR = new Color(0, 0, 0);
    private static final Color DISABLED_BACKGROUND_COLOR = new Color(255, 255, 255, 110);
    private static final Color DISABLED_FOREGROUND_COLOR = new Color(63, 63, 63);

    @Override
    public void installUI(JComponent jc) {
        super.installUI(jc);
        jc.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        MultiLineLabel label = (MultiLineLabel)c;
        if (label.isEnabled()) {
            g2d.translate(0, 1);
            g2d.setColor(ENABLED_BACKGROUND_COLOR);
            this.paintText(label, g2d);
            g2d.translate(0, -1);
            if (GuiUtils.isParentWindowFocused(label)) {
                g2d.setColor(ENABLED_FOREGROUND_COLOR);
            } else {
                g2d.setColor(DISABLED_FOREGROUND_COLOR);
            }
            this.paintText(label, g2d);
        } else {
            g2d.translate(0, 1);
            g2d.setColor(DISABLED_BACKGROUND_COLOR);
            this.paintText(label, g2d);
            g2d.translate(0, -1);
            g2d.setColor(DISABLED_FOREGROUND_COLOR);
            this.paintText(label, g2d);
        }
        g2d.dispose();
    }
}

