/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class PseudoOrthographic
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Pseudo-Orthographic";
    public static final int PROPERTIES = 8;
    private static final double MAX_X_OVER_RS = 2.0;
    private static final double MAX_Y_OVER_RS = 1.0;
    private double inv2RS_;

    public PseudoOrthographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public PseudoOrthographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.0, 1.0);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.inv2RS_ = 0.5 * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double halfLambdaRad = 0.5 * lambdaRad;
        double phiRad = Math.toRadians(lat);
        double x = 2.0 * Math.cos(phiRad) * Math.sin(halfLambdaRad);
        double y = Math.sin(phiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        if (absx < 1.0E-10 && absy < 1.0E-10) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double phiRad = Math.asin(y);
        double phi = Math.toDegrees(phiRad);
        if (absx < 1.0E-10) {
            return new PointLL(this.lambdaC_, phi);
        }
        double sinHalfLambda = absx * this.inv2RS_ / Math.cos(phiRad);
        double lambdaRad = 2.0 * Math.asin(sinHalfLambda);
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        PseudoOrthographic pseudoOrthographic = this;
        synchronized (pseudoOrthographic) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = Math.asin(yOverRS);
                double invCosPhi = 1.0 / Math.cos(phiRad);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOver2RS = x * this.inv2RS_;
                    if (Math.hypot(xOver2RS, yOverRS) > 1.0) continue;
                    double sinHalfLambda = xOver2RS * invCosPhi;
                    double lambdaRad = 2.0 * Math.asin(sinHalfLambda);
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }
}

