/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public class DouglasPeuckerSimplifier {
    private Point2D.Double[] pts_;
    private boolean[] usePt_;
    private double distanceTolerance_;
    private LineSegment seg_;
    private boolean isBound_;
    private double bound1_;
    private double bound2_;

    public static Point2D.Double[] simplify(Point2D.Double[] pts, double distanceTolerance) {
        DouglasPeuckerSimplifier dps = new DouglasPeuckerSimplifier(pts);
        dps.setDistanceTolerance(distanceTolerance);
        return dps.simplify();
    }

    public static Point2D.Double[] simplify(Point2D.Double[] pts, double distanceTolerance, double bound1, double bound2) {
        DouglasPeuckerSimplifier dps = new DouglasPeuckerSimplifier(pts);
        dps.setDistanceTolerance(distanceTolerance);
        return dps.simplify();
    }

    public DouglasPeuckerSimplifier(Point2D.Double[] pts) {
        this.pts_ = pts;
        this.seg_ = new LineSegment();
    }

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance_ = distanceTolerance;
    }

    public void setRangeBounds(double bound1, double bound2) {
        if (this.isBad(bound1) || this.isBad(bound2)) {
            this.isBound_ = false;
        } else {
            this.bound1_ = bound1;
            this.bound2_ = bound2;
            this.isBound_ = true;
        }
    }

    public Point2D.Double[] simplify() {
        int i;
        int i2;
        this.usePt_ = new boolean[this.pts_.length];
        for (i2 = 0; i2 < this.pts_.length; ++i2) {
            this.usePt_[i2] = true;
        }
        if (this.isBound_) {
            int lminus = this.pts_.length - 1;
            for (i = 1; i < lminus; ++i) {
                if (this.isBad(this.pts_[i].x)) continue;
                if (this.pts_[i].x < this.bound1_ && this.pts_[i].x < this.bound2_) {
                    if (!(this.pts_[i - 1].x < this.bound1_) || !(this.pts_[i - 1].x < this.bound2_) || !(this.pts_[i + 1].x < this.bound1_) || !(this.pts_[i + 1].x < this.bound2_)) continue;
                    this.usePt_[i] = false;
                    continue;
                }
                if (!(this.pts_[i].x > this.bound1_) || !(this.pts_[i].x > this.bound2_) || !(this.pts_[i - 1].x > this.bound1_) || !(this.pts_[i - 1].x > this.bound2_) || !(this.pts_[i + 1].x > this.bound1_) || !(this.pts_[i + 1].x > this.bound2_)) continue;
                this.usePt_[i] = false;
            }
        }
        block2: for (i2 = 0; i2 < this.pts_.length; ++i2) {
            if (this.isBad(this.pts_[i2].y)) {
                if (i2 <= 1 || !this.isBad(this.pts_[i2 - 1].y)) continue;
                this.usePt_[i2] = false;
                continue;
            }
            if (i2 == this.pts_.length - 1) break;
            for (int j = i2 + 1; j < this.pts_.length; ++j) {
                if (!this.isBad(this.pts_[j].y)) {
                    if (j != this.pts_.length - 1) continue;
                    this.simplify(i2, j);
                    i2 = j;
                    continue;
                }
                if (j - i2 <= 1) continue block2;
                this.simplify(i2, j - 1);
                i2 = j;
                continue block2;
            }
        }
        ArrayList<Point2D.Double> clist = new ArrayList<Point2D.Double>();
        for (i = 0; i < this.pts_.length; ++i) {
            if (!this.usePt_[i]) continue;
            clist.add(new Point2D.Double(this.pts_[i].x, this.pts_[i].y));
        }
        return clist.toArray(new Point2D.Double[0]);
    }

    private boolean isBad(double value) {
        return Double.isNaN(value) || Double.isInfinite(value);
    }

    private void simplify(int i, int j) {
        int k;
        if (i + 1 == j) {
            return;
        }
        this.seg_.setEndPts(this.pts_[i], this.pts_[j]);
        double maxDistance = -1.0;
        int maxIndex = i;
        for (k = i + 1; k < j; ++k) {
            double distance = this.seg_.distance(this.pts_[k]);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxIndex = k;
        }
        if (maxDistance <= this.distanceTolerance_) {
            for (k = i + 1; k < j; ++k) {
                this.usePt_[k] = false;
            }
        } else {
            this.simplify(i, maxIndex);
            this.simplify(maxIndex, j);
        }
    }

    static class LineSegment {
        private Point2D.Double p0_;
        private Point2D.Double p1_;

        private LineSegment() {
            this.setEndPts(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0));
        }

        public LineSegment(Point2D.Double p0, Point2D.Double p1) {
            this.setEndPts(p0, p1);
        }

        public void setEndPts(Point2D.Double p0, Point2D.Double p1) {
            this.p0_ = p0;
            this.p1_ = p1;
        }

        public double distance(Point2D.Double p) {
            double s = ((this.p0_.y - p.y) * (this.p1_.x - this.p0_.x) - (this.p0_.x - p.x) * (this.p1_.y - this.p0_.y)) / ((this.p1_.x - this.p0_.x) * (this.p1_.x - this.p0_.x) + (this.p1_.y - this.p0_.y) * (this.p1_.y - this.p0_.y));
            return Math.abs(s) * Math.sqrt((this.p1_.x - this.p0_.x) * (this.p1_.x - this.p0_.x) + (this.p1_.y - this.p0_.y) * (this.p1_.y - this.p0_.y));
        }
    }
}

