/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLogScaleAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotMeta pmeta_;
    private long last_;
    private boolean busy_;

    public PanLogScaleAction(PanPlotMeta pmeta) {
        super(PanProperties.MENU_PROPS.getString("log-scale"));
        this.pmeta_ = pmeta;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        long now = System.currentTimeMillis();
        if (now - this.last_ >= 200L) {
            PanScaleMethod oldMethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
            PanScaleMethod newMethod = oldMethod == PanScaleMethod.SCALAR ? PanScaleMethod.LOG10 : PanScaleMethod.SCALAR;
            this.pmeta_.setString("scale.method", newMethod.toString());
        }
        EventQueue.invokeLater(() -> this.pmeta_.getFrame().refreshMenu("plot-menu"));
        this.last_ = now;
        this.busy_ = false;
    }
}

