/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArray2DTableModel
extends PanArrayTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcArray2D array_;

    public PanArray2DTableModel(NcArray2D array) {
        this.array_ = array;
    }

    @Override
    public int getColumnCount() {
        try {
            int cols = this.array_.getXAxis().getLength();
            if (cols > 105000) {
                return 100001;
            }
            return cols;
        }
        catch (Exception exc) {
            return 0;
        }
    }

    @Override
    public int getRowCount() {
        try {
            int rows = this.array_.getYAxis().getLength();
            if (rows > 105000) {
                return 100001;
            }
            return rows;
        }
        catch (Exception exc) {
            return 0;
        }
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        try {
            int colx;
            int cols = this.array_.getXAxis().getLength();
            if (col == 100000 && cols > 105000) {
                return "more...";
            }
            int n = colx = this.flippedLR_ ? cols - 1 - col : col;
            if (this.showCellIndex_) {
                return Integer.toString(colx + 1);
            }
            double val = this.array_.getXAxis().valueAt(colx);
            return this.hdrFormatter_.sprintfx(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public String getRowName(int row) {
        try {
            int rowx;
            int rows = this.array_.getYAxis().getLength();
            if (rows > 105000) {
                return "more...";
            }
            int n = rowx = this.flippedBT_ ? rows - 1 - row : row;
            if (this.showCellIndex_) {
                return Integer.toString(rowx + 1);
            }
            double val = this.array_.getYAxis().valueAt(rowx);
            return this.hdrFormatter_.sprintfx(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            int cols = this.array_.getXAxis().getLength();
            int rows = this.array_.getYAxis().getLength();
            if (col == 100000 && cols > 105000) {
                return "more...";
            }
            if (row == 100000 && rows > 105000) {
                return "more...";
            }
            int rowx = this.flippedBT_ ? rows - 1 - row : row;
            int colx = this.flippedLR_ ? cols - 1 - col : col;
            return this.valFormatter_.sprintfx(this.array_.valueAt(colx, rowx));
        }
        catch (Exception ignore) {
            return "ERR";
        }
    }

    @Override
    public void setFlipBT(boolean flipped) {
        this.flippedBT_ = flipped;
        this.fireTableDataChanged();
    }

    @Override
    public boolean canFlipLR() {
        return true;
    }

    @Override
    public void setFlipLR(boolean flipped) {
        this.flippedLR_ = flipped;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }
}

