/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import javax.swing.JComboBox;

public final class PanScaleMethodComboBox
extends JComboBox<PanScaleMethod> {
    private PanScaleMethodComboBox(SizeVariant size, String name) {
        this.addItem(PanScaleMethod.SCALAR);
        this.addItem(PanScaleMethod.LOG10);
        if (PanUtils.isDevoLogEScale()) {
            this.addItem(PanScaleMethod.LOG_E);
        }
        if (name != null) {
            this.setName(name);
        }
        GuiUtils.applyComboBoxUI(this, size);
    }

    public static PanScaleMethodComboBox create(String name) {
        return new PanScaleMethodComboBox(SizeVariant.REGULAR, name);
    }

    public static PanScaleMethodComboBox small(String name) {
        return new PanScaleMethodComboBox(SizeVariant.SMALL, name);
    }

    public PanScaleMethod getSelectedMethod() {
        int idx = this.getSelectedIndex();
        return (PanScaleMethod)this.getItemAt(idx);
    }

    public String getStringValue() {
        int idx = this.getSelectedIndex();
        PanScaleMethod item = (PanScaleMethod)this.getItemAt(idx);
        return item.name();
    }

    public void setSelectedItem(String s) {
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            PanScaleMethod pam = (PanScaleMethod)this.getItemAt(i);
            if (!pam.matches(s)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }
}

