/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util.reslist;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceListEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PATH_SEP = System.getProperty("file.separator");
    protected LocType loctype_;
    protected Object address_;
    protected String name_;
    protected Object item_;
    private boolean favorite_ = true;
    private boolean invalid_;

    public ResourceListEntry(LocType loctype, Object address, Object item) {
        Objects.requireNonNull(address, "Address cannot be null.");
        this.loctype_ = loctype;
        this.address_ = address;
        this.item_ = item;
        if (address instanceof File) {
            this.name_ = ((File)address).getName();
        } else if (address instanceof URL) {
            String astring = this.address_.toString();
            int lastSlash = astring.lastIndexOf(47);
            int lastSeparator = Math.max(lastSlash, astring.lastIndexOf(PATH_SEP));
            this.name_ = astring.substring(lastSeparator + 1);
        } else {
            throw new IllegalArgumentException("Address must be File or URL, not " + address.getClass().getSimpleName());
        }
    }

    public String toString() {
        return this.name_;
    }

    public String getName() {
        return this.name_;
    }

    public boolean isInvalid() {
        return this.invalid_;
    }

    protected void setInvalid() {
        this.invalid_ = true;
    }

    Object getObject() {
        if (this.invalid_) {
            return null;
        }
        if (this.item_ == null) {
            try {
                if (this.address_ instanceof File) {
                    this.load((File)this.address_);
                } else {
                    this.load((URL)this.address_);
                }
            }
            catch (Exception exc) {
                this.setInvalid();
                LOGGER.warn("Unable to load resource {}", (Object)this.getName());
                throw new RuntimeException("Unable to load resource " + this.getName());
            }
        }
        return this.item_;
    }

    LocType getLocType() {
        return this.loctype_;
    }

    Object getAddress() {
        return this.address_;
    }

    boolean isInUserLib() {
        return this.loctype_ == LocType.USERLIB;
    }

    protected abstract void load(File var1);

    protected abstract void load(URL var1);

    public boolean isFavorite() {
        return this.favorite_;
    }

    public void setFavorite(boolean fave) {
        this.favorite_ = fave;
    }

    public static enum LocType {
        INCODE,
        JAR,
        USERLIB,
        OTHER;

    }
}

