/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcException;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.NoSuchUnitException;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;
import ucar.units.UnitParseException;

public final class NcUnitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final UnitFormat FORMATTER = UnitFormatManager.instance();
    private static boolean altEnabled_;
    private static Hashtable<String, String> alternatives_;

    public static boolean isAltEnabled() {
        return altEnabled_;
    }

    public static void setAltEnabled(boolean enabled) {
        LOGGER.trace("{}", (Object)enabled);
        altEnabled_ = enabled;
    }

    public static void addAlternative(String altStr, String forStr) {
        Objects.requireNonNull(altStr, "Alternative units string cannot be null.");
        Objects.requireNonNull(forStr, "UDUNITS compatible string cannot be null.");
        try {
            FORMATTER.parse(forStr);
        }
        catch (Exception exc) {
            throw new NcException(exc.toString());
        }
        LOGGER.trace("{}, {}", (Object)altStr, (Object)forStr);
        alternatives_.put(altStr, forStr);
    }

    public static String removeAlternative(String altStr) {
        return alternatives_.remove(altStr);
    }

    public static Unit parse(String unitsStr) throws NcException, NoSuchUnitException, UnitParseException {
        String goodUnitStr;
        if (unitsStr == null || unitsStr.isEmpty()) {
            return null;
        }
        if ("nounits".equals(unitsStr.toLowerCase())) {
            return null;
        }
        String xunitsStr = unitsStr;
        if (altEnabled_ && (goodUnitStr = alternatives_.get(unitsStr)) != null) {
            LOGGER.trace("Replace '{}' with '{}'", (Object)xunitsStr, (Object)goodUnitStr);
            xunitsStr = goodUnitStr;
        }
        try {
            return FORMATTER.parse(xunitsStr);
        }
        catch (NoSuchUnitException exc) {
            LOGGER.debug("NoSuchUnitException parsing '{}'", (Object)xunitsStr);
            throw exc;
        }
        catch (UnitParseException exc) {
            LOGGER.debug("UnitParseException parsing '{}'", (Object)xunitsStr);
            throw exc;
        }
        catch (Exception exc) {
            LOGGER.debug("Exception {} parsing '{}'", (Object)exc.getClass(), (Object)xunitsStr);
            String excStr = exc.toString().replaceFirst(".*: ", "");
            throw new NcException(excStr);
        }
    }

    public static boolean isCompatible(Unit u1, Unit u2) {
        if (u1 == null && u2 == null) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return u2.isCompatible(u1);
    }

    public static boolean isCompatible(String ustr1, String ustr2) {
        if (ustr1 == null && ustr2 == null) {
            return true;
        }
        if (ustr1 == null || ustr2 == null) {
            return false;
        }
        if (ustr1.isEmpty() && ustr2.isEmpty()) {
            return true;
        }
        try {
            Unit u1 = NcUnitUtils.parse(ustr1);
            Unit u2 = NcUnitUtils.parse(ustr2);
            return u2.isCompatible(u1);
        }
        catch (Exception exc) {
            LOGGER.warn("Units string could not be parse.");
            return false;
        }
    }

    public static boolean isDegreesEast(String ustr) {
        if (ustr == null || ustr.isEmpty()) {
            return false;
        }
        return "degrees_east".equalsIgnoreCase(ustr) || "degree_east".equalsIgnoreCase(ustr) || "degrees_E".equals(ustr) || "degree_E".equals(ustr) || "degreesE".equals(ustr) || "degreeE".equals(ustr) || "deg_east".equalsIgnoreCase(ustr) || "deg_e".equalsIgnoreCase(ustr);
    }

    public static boolean isDegreesNorth(String ustr) {
        if (ustr == null || ustr.isEmpty()) {
            return false;
        }
        return "degrees_north".equalsIgnoreCase(ustr) || "degree_north".equalsIgnoreCase(ustr) || "degrees_N".equals(ustr) || "degree_N".equals(ustr) || "degreesN".equals(ustr) || "degreeN".equals(ustr) || "deg_north".equalsIgnoreCase(ustr) || "deg_n".equalsIgnoreCase(ustr);
    }

    public static boolean isDegreesSouth(String ustr) {
        if (ustr == null || ustr.isEmpty()) {
            return false;
        }
        return "degrees_south".equalsIgnoreCase(ustr) || "degree_south".equalsIgnoreCase(ustr) || "degrees_S".equals(ustr) || "degree_S".equals(ustr) || "degreesS".equals(ustr) || "degreeS".equals(ustr) || "deg_south".equalsIgnoreCase(ustr) || "deg_S".equalsIgnoreCase(ustr);
    }

    private NcUnitUtils() {
    }

    static {
        alternatives_ = new Hashtable(5);
    }
}

