/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLatVert;
import gov.nasa.giss.text.PrintfFormat;
import java.util.Objects;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLatVert
extends NcArray2D {
    public NcArrayLatVert(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.createAxes();
        this.measureAxes();
    }

    @Override
    protected void createAxes() {
        int dindex;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = this.getCoordinateAxisOfType(NcAxisType.LAT);
        CoordinateAxis y = this.getCoordinateAxisOfType(NcAxisType.VERT);
        if (x == null) {
            VariableDS cv = this.getCoordinateVariable(NcAxisType.LAT);
            if (cv != null) {
                this.xAxis_ = new NcAxis(NcAxisType.LAT, ncd, cv);
                this.xDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcAxis(NcAxisType.LAT, ncd, x);
            this.xDimIndex_ = this.findDimensionIndex(x);
        }
        if (y != null) {
            this.yAxis_ = new NcAxis(NcAxisType.VERT, this.getDataset(), y);
            this.yDimIndex_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcNullException("Found null when retrieving LAT coordinate axis");
        }
        if (this.yAxis_ == null) {
            throw new NcNullException("Found null when retrieving VERT coordinate axis");
        }
        if (this.xDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for LAT axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for VERT axis");
        }
        CoordinateAxis lonaxis = this.getCoordinateAxisOfType(NcAxisType.LON);
        if (lonaxis instanceof CoordinateAxis1D && lonaxis.getRank() == 1 && lonaxis.getShape()[0] > 0 && (dindex = this.findDimensionIndex(lonaxis)) > -1) {
            this.setAveDimIndex(dindex);
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLatVert();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (row < 0 || col < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double lat = this.getXAxis().valueAt(col);
        double yy = this.getYAxis().valueAt(row);
        double value = this.valueAt(col, row);
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(NcUtils.formatLatitude(lat)).append(", ").append(new PrintfFormat("%.10g").sprintfx(yy));
        if (this.getYAxis().getUnitsStr() != null) {
            sb.append(' ').append(this.getYAxis().getUnitsStr());
        }
        sb.append("], value = ").append(valFormat.sprintfx(value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }
}

