/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.map.LonLatEdges;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NcArrayLonLat {
    public int[] getEnclosingCell(double var1, double var3);

    default public LonLatEdges getLonLatEdges() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.warn("Not yet implemented.");
        return null;
    }

    default public double[] aveFourLL(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double lon4, double lat4) {
        return new double[]{0.25 * (lon1 + lon2 + lon3 + lon4), 0.25 * (lat1 + lat2 + lat3 + lat4)};
    }

    public static boolean isBadLongitude(double lon) {
        return lon > 720.0 || lon < -720.0 || Double.isNaN(lon);
    }

    public static boolean isBadLatitude(double lat) {
        return Double.isNaN(lat) || Math.abs(lat) > 90.0;
    }

    public static boolean isBadLonLat(double lon, double lat) {
        return NcArrayLonLat.isBadLongitude(lon) || NcArrayLonLat.isBadLatitude(lat);
    }
}

