/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatCartesian;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatCartesian
extends NcArray2D
implements NcArrayLonLat {
    public NcArrayLonLatCartesian(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.createAxes();
        this.measureAxes();
    }

    @Override
    protected void createAxes() {
        VariableDS cv;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = this.getCoordinateAxisOfType(NcAxisType.LON);
        CoordinateAxis y = this.getCoordinateAxisOfType(NcAxisType.LAT);
        if (x == null) {
            cv = this.getCoordinateVariable(NcAxisType.LON);
            if (cv != null) {
                this.xAxis_ = new NcAxis(NcAxisType.LON, ncd, cv);
                this.xDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcAxis(NcAxisType.LON, ncd, x);
            this.xDimIndex_ = this.findDimensionIndex(x);
        }
        if (this.xAxis_ == null) {
            throw new NcNullException("Found null when retrieving LON coordinate axis");
        }
        if (this.xDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for LON axis");
        }
        if (y == null) {
            cv = this.getCoordinateVariable(NcAxisType.LAT);
            if (cv != null) {
                this.yAxis_ = new NcAxis(NcAxisType.LAT, ncd, cv);
                this.yDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.yAxis_ = new NcAxis(NcAxisType.LAT, ncd, y);
            this.yDimIndex_ = this.findDimensionIndex(y);
        }
        if (this.yAxis_ == null) {
            throw new NcNullException("Found null when retrieving LAT coordinate axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for LAT axis");
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatCartesian();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double lon = this.xAxis_.valueAt(col);
        double lat = this.yAxis_.valueAt(row);
        double gv = this.valueAt(col, row);
        sb.append("Cell  [").append(colDisplay).append(',').append(rowDisplay).append(']').append(" at [").append(NcUtils.formatLongitude(lon)).append(' ').append(NcUtils.formatLatitude(lat)).append("], value = ").append(valFormat.sprintfx(gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }

    @Override
    public LonLatEdges getLonLatEdges() {
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        double west = Math.min(xBounds[0][0], xBounds[xBounds.length - 1][1]);
        double east = Math.max(xBounds[0][0], xBounds[xBounds.length - 1][1]);
        double north = Math.max(yBounds[0][0], yBounds[yBounds.length - 1][1]);
        double south = Math.min(yBounds[0][0], yBounds[yBounds.length - 1][1]);
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.trace("W {}, N {}, E {}, S {}", west, north, east, south);
        return new LonLatEdges(west, north, east, south);
    }
}

