/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.plot.PlotPiece;
import gov.nasa.giss.graphics.plot.PlotPieceContainer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotHolder
extends JComponent
implements PlotPieceContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PlotPiece plot_;

    public PlotHolder(PlotPiece plot) {
        this.setOpaque(false);
        this.attach(plot);
    }

    public PlotPiece getPlot() {
        return this.plot_;
    }

    @Override
    public final void attach(PlotPiece plot) {
        PlotPieceContainer oldParent;
        Objects.requireNonNull("PlotPiece cannot be null");
        if (this.plot_ != null) {
            this.detach(this.plot_);
        }
        if ((oldParent = plot.getParent()) != null) {
            oldParent.detach(plot);
        }
        this.plot_ = plot;
        this.plot_.setParent(this);
        Insets ins = this.getInsets();
        this.plot_.setLocation(ins.left, ins.top);
    }

    @Override
    public final boolean detach(PlotPiece piece) {
        if (piece != this.plot_) {
            return false;
        }
        this.plot_.setParent(null);
        this.plot_ = null;
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        if (this.plot_ == null) {
            LOGGER.warn("No plot yet attached. Returning simple dimension.");
            return new Dimension(ins.left + 2 + ins.right, ins.top + 2 + ins.bottom);
        }
        Dimension pd = this.plot_.getSize();
        return new Dimension(ins.left + pd.width + ins.right, ins.top + pd.height + ins.bottom);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintComponent(g, false);
    }

    @Override
    public void printComponent(Graphics g) {
        this.paintComponent(g, true);
    }

    private void paintComponent(Graphics g, boolean printing) {
        Rectangle clip = g.getClipBounds();
        Rectangle rr = this.plot_.getBounds();
        if (rr.width == 0 || rr.height == 0) {
            return;
        }
        Rectangle ri = clip == null ? rr : clip.intersection(rr);
        g.setClip(ri);
        Graphics2D g2d = (Graphics2D)g.create();
        GraphicUtils.antialias(g2d);
        g2d.translate(rr.x, rr.y);
        if (printing) {
            this.plot_.print(g2d);
        } else {
            this.plot_.paint(g2d);
        }
        g2d.dispose();
        g.setClip(clip);
    }
}

