/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.img.TiffUtils;
import gov.nasa.giss.io.FileUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Dimension getImageDimensions(File f) throws FileNotFoundException, IOException, UnsupportedOperationException {
        Dimension dd;
        Objects.requireNonNull(f, "File object cannot be null");
        String lcext = FileUtils.extractFnameExt(f).toLowerCase();
        try (FileImageInputStream fiis = new FileImageInputStream(f);){
            Dimension dd2 = ImageUtils.getImageDimensions(fiis, lcext);
            if (dd2 != null) {
                Dimension dimension = dd2;
                return dimension;
            }
        }
        if ((lcext.equalsIgnoreCase("tif") || lcext.equalsIgnoreCase("tiff")) && (dd = TiffUtils.getImageDimensions(f)) != null) {
            return dd;
        }
        throw new UnsupportedOperationException("No header reader available for that image type.");
    }

    private static Dimension getImageDimensions(FileImageInputStream fiis, String fext) throws IOException {
        Objects.requireNonNull(fext, "Extension cannot be null");
        String lcext = fext.toLowerCase();
        Iterator<ImageReader> readers = ImageIO.getImageReaders(fiis);
        if (!readers.hasNext()) {
            LOGGER.debug("No readers found");
            readers = ImageIO.getImageReadersBySuffix(lcext);
        }
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            reader.setInput(fiis);
            Dimension d = new Dimension(reader.getWidth(0), reader.getHeight(0));
            reader.dispose();
            return d;
        }
        return null;
    }

    public static ImageIcon getImageIconOfSize(URL resource, int width, int height) {
        ImageIcon ii = new ImageIcon(resource);
        Image img = ii.getImage().getScaledInstance(width, height, 4);
        return new ImageIcon(img);
    }

    public static BufferedImage toBufferedImage(Icon icon) {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage bimage = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)bimage.getGraphics();
        if (icon instanceof ImageIcon) {
            g2d.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
        } else {
            icon.paintIcon(null, g2d, 0, 0);
        }
        g2d.dispose();
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        Image iimage = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(iimage);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = hasAlpha ? 2 : 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(iimage.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = hasAlpha ? 2 : 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    public static int[] getARGBPixels(BufferedImage img) {
        Objects.requireNonNull(img, "Image cannot be null");
        int biType = img.getType();
        WritableRaster raster = img.getRaster();
        LOGGER.debug("bitype {}", (Object)biType);
        LOGGER.debug("dttype {}", (Object)raster.getTransferType());
        LOGGER.debug("model class {}", (Object)img.getColorModel().getClass().getSimpleName());
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int[] pixels = new int[w * h];
        switch (biType) {
            case 1: {
                raster.getDataElements(0, 0, w, h, pixels);
                if (biType != 1) break;
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] | 0xFF000000;
                }
                break;
            }
            case 2: {
                raster.getDataElements(0, 0, w, h, pixels);
                break;
            }
            case 3: {
                raster.getDataElements(0, 0, w, h, pixels);
                if (biType != 1) break;
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] | 0xFF000000;
                }
                break;
            }
            case 5: {
                byte[] scratch = new byte[3 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = -16777216 + (scratch[i * 3 + 2] & 0xFF) + ((scratch[i * 3 + 1] & 0xFF) << 8) + ((scratch[i * 3 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 6: {
                byte[] scratch = new byte[4 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = ((scratch[i * 4 + 3] & 0xFF) << 24) + (scratch[i * 4 + 2] & 0xFF) + ((scratch[i * 4 + 1] & 0xFF) << 8) + ((scratch[i * 4 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 7: {
                byte[] scratch = new byte[4 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = -16777216 + (scratch[i * 4 + 2] & 0xFF) + ((scratch[i * 4 + 1] & 0xFF) << 8) + ((scratch[i * 4 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 12: 
            case 13: {
                IndexColorModel icm = (IndexColorModel)img.getColorModel();
                int transIdx = icm.getTransparentPixel();
                byte[] rowPixels = new byte[w];
                for (int row = 0; row < h; ++row) {
                    raster.getDataElements(0, row, w, 1, rowPixels);
                    for (int col = 0; col < w; ++col) {
                        int idx = rowPixels[col] & 0xFF;
                        pixels[row * w + col] = idx == transIdx ? 0 : 0xFF000000 | icm.getRGB(idx);
                    }
                }
                break;
            }
            default: {
                LOGGER.trace("Using pixel grabber to decode pixels.");
                try {
                    PixelGrabber grabber = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
                    grabber.grabPixels();
                    break;
                }
                catch (InterruptedException exc) {
                    LOGGER.debug("Couldn't get pixels from PixelGrabber.");
                    LOGGER.debug("Returning unfilled array!");
                    if (!LOGGER.isTraceEnabled()) break;
                    exc.printStackTrace();
                }
            }
        }
        return pixels;
    }

    private ImageUtils() {
    }
}

