/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.img.TiffFieldType;
import gov.nasa.giss.img.TiffTag;

public class TiffIfdEntry
implements Comparable<TiffIfdEntry> {
    private TiffTag tag_;
    private TiffFieldType ftype_;
    private int count_;
    private int offset_;
    private int[] valuesI_;
    private double[] valuesD_;
    private String valuesS_;

    public TiffIfdEntry(TiffTag tag, TiffFieldType ftype) {
        this(tag, ftype, 1);
    }

    public TiffIfdEntry(TiffTag tag, TiffFieldType ftype, int count) {
        this.tag_ = tag;
        this.ftype_ = ftype;
        this.count_ = count;
    }

    public TiffTag getTag() {
        return this.tag_;
    }

    public TiffFieldType getType() {
        return this.ftype_;
    }

    public int getSize() {
        return this.count_ * this.ftype_.getSize();
    }

    public TiffIfdEntry setIntValues(int ... v) {
        this.valuesI_ = new int[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.valuesI_[i] = v[i];
        }
        return this;
    }

    public TiffIfdEntry setDoubleValues(double ... v) {
        this.valuesD_ = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.valuesD_[i] = v[i];
        }
        return this;
    }

    public TiffIfdEntry setStringValue(String v) {
        this.valuesS_ = v;
        return this;
    }

    public int getOffset() {
        return this.offset_;
    }

    public TiffIfdEntry setOffset(int offset) {
        this.offset_ = offset;
        return this;
    }

    @Override
    public int compareTo(TiffIfdEntry o) {
        int i1 = this.tag_.getCode();
        int i2 = o.getTag().getCode();
        return i1 - i2;
    }
}

