/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection2H;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ginzburg2TwoH
extends AzimuthalProjection2H {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double CONST_A = 2.5E-4;
    private static final double CONST_Q = 10.0;
    private static final double AQ = 0.0025;
    private static final double Q_MINUS_1 = 9.0;
    public static final String PROJECTION_NAME = "Ginzburg II (Two-Hemisphere)";
    private static final double RADIUS_FACTOR = 2.0 * Math.sin(0.7853981633974483) + 2.5E-4 * Math.pow(1.5707963267948966, 10.0);

    public Ginzburg2TwoH(int width, int height) {
        this(width, height, 0, 0);
    }

    public Ginzburg2TwoH(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 44040256, width, height, xmargin, ymargin, RADIUS_FACTOR);
        this.finishConstruction();
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        double z = Math.acos(cosZ);
        double rho = 2.0 * Math.sin(0.5 * z) + 2.5E-4 * Math.pow(z, 10.0);
        double rho2 = rho * rho;
        if (rho2 * this.r2s2_ > this.rhoBorder2_) {
            return -1.0;
        }
        return rho / Math.sin(z);
    }

    @Override
    protected final double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double z = rhoOverRS * 1.5707963267948966;
        for (int iter = 0; iter < 33; ++iter) {
            double halfZ = 0.5 * z;
            double sinHalfZ = Math.sin(halfZ);
            double cosHalfZ = Math.cos(halfZ);
            double func = 2.0 * sinHalfZ + 2.5E-4 * Math.pow(z, 10.0) - rhoOverRS;
            double dfunc = cosHalfZ + 0.0025 * Math.pow(z, 9.0);
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

