/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyorffyB
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Gy\u00f6rffy B";
    public static final int PROPERTIES = 8;
    private static final double C1 = 0.75762;
    private static final double C2 = 2.0;
    private static final double C3 = 4.63375;
    private static final double C4 = 0.00264;
    private static final double ONE_OVER_C3 = 0.21580793094146208;
    private static final double MAX_X_OVER_RS = 2.4421496011064145;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public GyorffyB(int width, int height) {
        this(width, height, 0, 0);
    }

    public GyorffyB(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.4421496011064145, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double lambdaRad2 = lambdaRad * lambdaRad;
        double x = GyorffyB.getC1Term(absPhiRad) * absLambdaRad * (1.0 + 0.00264 * lambdaRad2);
        double y = absPhiRad;
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double phiRad = absy * this.invRS_;
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = GyorffyB.iterateLambdaRad(absx * this.invRS_, phiRad);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GyorffyB gyorffyB = this;
        synchronized (gyorffyB) {
            double y;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > (double)this.dyMax_); ++iy) {
                double lambdaRad;
                double x;
                double phiRad = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && !((x = (double)ix + 0.5) > (double)this.dxMax_) && !((lambdaRad = GyorffyB.iterateLambdaRad(x * this.invRS_, phiRad)) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getC1Term(double phiRad) {
        return 0.75762 * Math.pow(1.0 - Math.pow(0.6366197723675814 * phiRad, 2.0), 0.21580793094146208);
    }

    private static double iterateLambdaRad(double xOverRS, double phiRad) {
        double c1Term = GyorffyB.getC1Term(phiRad);
        double lambdaRad = Math.PI * (xOverRS / 2.4421496011064145);
        for (int iter = 0; iter < 33; ++iter) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double c4LambdaRad2 = 0.00264 * lambdaRad2;
            double func = c1Term * lambdaRad * (1.0 + 0.00264 * lambdaRad2) - xOverRS;
            double dfunc = c1Term * (1.0 + 3.0 * c4LambdaRad2);
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }
}

