/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Parabolic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Parabolic";
    private static final double SQRT_3PI = 3.0699801238394655;
    private static final double SQRT_3OVERPI = 0.9772050238058397;
    private static final double MAX_X_OVER_RS = 3.0699801238394655;
    private static final double MAX_Y_OVER_RS = 1.5349900619197328;
    private double invRSSqrt3Pi_;
    private double rSSqrt3OverPi_;
    private double invRSSqrt3OverPi_;

    public Parabolic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Parabolic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, 3.0699801238394655, 1.5349900619197328);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.invRSSqrt3Pi_ = 1.0 / (this.rS_ * 3.0699801238394655);
        this.rSSqrt3OverPi_ = this.rS_ * 0.9772050238058397;
        this.invRSSqrt3OverPi_ = 1.0 / this.rSSqrt3OverPi_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) < 1.0E-10) {
            double x2 = 0.9772050238058397 * this.lonToLambdaRad(lon);
            double y = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x2, y);
        }
        double phiRadOver3 = Math.toRadians(lat) / 3.0;
        double y = 3.0699801238394655 * Math.sin(phiRadOver3);
        if (this.isInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double nlon = MapUtils.normalizeMP180(lon);
            double dlon = nlon - gore[1];
            double dx = 0.9772050238058397 * Math.toRadians(dlon) * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
            double cx = 0.9772050238058397 * this.lonToLambdaRad(gore[1]);
            x = cx + dx;
        } else {
            x = 0.9772050238058397 * this.lonToLambdaRad(lon) * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = 3.0 * Math.asin(y * this.invRSSqrt3Pi_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = 1.0 / (this.rSSqrt3OverPi_ * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
        double lon = this.getLongitudeForX(x, xFactor, this.invRSSqrt3OverPi_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Parabolic parabolic = this;
        synchronized (parabolic) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double phiRad = 3.0 * Math.asin(y * this.invRSSqrt3Pi_);
                if (phiRad < -1.5707963267948966) continue;
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                double xFactor = 1.0 / (this.rSSqrt3OverPi_ * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRSSqrt3OverPi_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

