/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.shapefile;

import gov.nasa.giss.map.shapefile.ShapeException;
import gov.nasa.giss.map.shapefile.ShapeRecord;
import gov.nasa.giss.map.shapefile.ShapeRecordType;
import gov.nasa.giss.map.shapefile.ShapeUtils;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class ShapeRecordPolygon
extends ShapeRecord {
    private Point2D.Double[] pts_;
    private int[] partOffsets_;
    private double[] mVals_;
    private double[] mRange_;
    private double[] zVals_;
    private double[] zRange_;

    @Override
    void readFromBuffer(byte[] buffer) {
        this.recordType_ = ShapeUtils.shapeTypeFromBytes(buffer, 0);
        if (!this.isPolygon()) {
            throw new ShapeException("Shape type is not Polygon.");
        }
        double[] bounds = ShapeUtils.doublesFromLittleBytes(buffer, 4, 4);
        this.left_ = bounds[0];
        this.top_ = bounds[3];
        this.right_ = bounds[2];
        this.bottom_ = bounds[1];
        this.numParts_ = ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(buffer, 36, 4));
        this.numPoints_ = ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(buffer, 40, 4));
        this.partOffsets_ = ShapeUtils.intsFromLittleBytes(buffer, 44, this.numPoints_);
        int ptOffset = 44 + this.numParts_ * 4;
        this.pts_ = ShapeUtils.pointsFromLittleBytes(buffer, ptOffset, this.numPoints_);
        if (this.recordType_ == ShapeRecordType.POLYGON) {
            return;
        }
        int mOffset = 0;
        int zOffset = 0;
        if (this.recordType_ == ShapeRecordType.POLYGON_M) {
            mOffset = ptOffset + this.numPoints_ * 2 * 8;
        } else if (this.recordType_ == ShapeRecordType.POLYGON_Z) {
            zOffset = ptOffset + this.numPoints_ * 2 * 8;
            mOffset = zOffset + 16 + this.numPoints_ * 8;
        }
        if (mOffset < buffer.length) {
            this.mRange_ = ShapeUtils.doublesFromLittleBytes(buffer, mOffset, 2);
            this.mVals_ = ShapeUtils.doublesFromLittleBytes(buffer, mOffset + 16, this.numPoints_);
        }
        if (this.recordType_ == ShapeRecordType.POLYGON_Z) {
            this.zRange_ = ShapeUtils.doublesFromLittleBytes(buffer, zOffset, 2);
            this.zVals_ = ShapeUtils.doublesFromLittleBytes(buffer, zOffset + 16, this.numPoints_);
        }
    }

    @Override
    public Point2D.Double[] getPoints(int partNum) {
        if (partNum < 0 || partNum >= this.numParts_) {
            throw new IllegalArgumentException("Part number out of range.");
        }
        if (partNum < this.numParts_ - 1) {
            return Arrays.copyOfRange(this.pts_, this.partOffsets_[partNum], this.partOffsets_[partNum + 1]);
        }
        return Arrays.copyOfRange(this.pts_, this.partOffsets_[partNum], this.numPoints_);
    }

    public double[] getMRange() {
        return this.mRange_;
    }

    public double[] getZRange() {
        return this.zRange_;
    }

    public double[] getMValues(int partNum) {
        if (partNum < 0 || partNum >= this.numParts_) {
            throw new IllegalArgumentException("Part number out of range.");
        }
        if (this.mVals_ == null) {
            return null;
        }
        if (partNum < this.numParts_ - 1) {
            return Arrays.copyOfRange(this.mVals_, this.partOffsets_[partNum], this.partOffsets_[partNum + 1]);
        }
        return Arrays.copyOfRange(this.mVals_, this.partOffsets_[partNum], this.numPoints_);
    }

    public double[] getZValues(int partNum) {
        if (partNum < 0 || partNum >= this.numParts_) {
            throw new IllegalArgumentException("Part number out of range.");
        }
        if (this.zVals_ == null) {
            return null;
        }
        if (partNum < this.numParts_ - 1) {
            return Arrays.copyOfRange(this.zVals_, this.partOffsets_[partNum], this.partOffsets_[partNum + 1]);
        }
        return Arrays.copyOfRange(this.zVals_, this.partOffsets_[partNum], this.numPoints_);
    }
}

