/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.dialog.PanExportGridDialog;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.task.PanExportGridTask;
import gov.nasa.giss.panoply.util.PanExportGridOption;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.SlowMessage;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportGridAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String NC3_EXT = "nc3";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-plotted-grid");
    private final PanPlotFrame parent_;

    public PanExportGridAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanData data = this.parent_.getData();
        if (!(data instanceof PanData2D)) {
            SlowMessage.show((Component)this.parent_, "Save Error", "We are currently only able to write a 2D data grid.");
            return;
        }
        PanExportGridDialog dlog = new PanExportGridDialog(this.parent_);
        dlog.setVisible(true);
        if (!dlog.isSuccessful()) {
            this.showWindoids();
            return;
        }
        Hashtable<PanExportGridOption, String> opts = dlog.getOptions();
        File file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export internal data grid as\u2026", opts.get((Object)PanExportGridOption.VARNAME) + "_export", NC3_EXT);
        if (file == null) {
            this.showWindoids();
            return;
        }
        opts.put(PanExportGridOption.FILEPATH, file.getPath());
        PanExportGridTask exportTask = new PanExportGridTask(this.parent_, file, opts);
        this.parent_.addTask(exportTask);
    }

    private void showWindoids() {
        EventQueue.invokeLater(() -> this.parent_.setWindoidsVisible(true));
    }
}

