/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.panoply.util.PanPlotType;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PCLPlotKeyTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Hashtable<PanPlotType, Hashtable<String, String>> hashOfHashes = new Hashtable();

    static String getTranslatedKey(PanPlotType ptype, String key) {
        String skey = key.replaceAll("\\-", ".");
        if ("include.scale".equals(key)) {
            LOGGER.info("Key {} has been replaced by {}", (Object)"include.scale", (Object)"include.colorbar");
            return "include.colorbar";
        }
        Hashtable<String, String> thash = PCLPlotKeyTranslator.getPlotTypeTranslations(ptype);
        if (thash != null && thash.containsKey(skey)) {
            String newkey = thash.get(skey);
            LOGGER.info("Key {} key has been replaced by {}", (Object)skey, (Object)newkey);
            return newkey;
        }
        if (!ptype.isLonLatMap() || skey.matches("(proj|center|border|overlay|numbers|shading).*")) {
            // empty if block
        }
        return skey;
    }

    static String getUntranslatedKey(PanPlotType ptype, String key) {
        LOGGER.trace("Not yet implemented.");
        return null;
    }

    static Hashtable<String, String> getPlotTypeTranslations(PanPlotType ptype) {
        switch (ptype) {
            case HORZ_LINE: 
            case LL_ZONAL: {
                return hashOfHashes.get(PanPlotType.HORZ_LINE);
            }
            case VERT_LINE: {
                return hashOfHashes.get(PanPlotType.VERT_LINE);
            }
        }
        return null;
    }

    private PCLPlotKeyTranslator() {
    }

    static {
        Hashtable<String, String> thash = new Hashtable<String, String>();
        thash.put("yaxis.method", "scale.method");
        thash.put("yaxis.begin", "scale.min");
        thash.put("yaxis.end", "scale.max");
        thash.put("yaxis.div.major", "scale.div.major");
        thash.put("yaxis.div.minor", "scale.div.minor");
        thash.put("yaxis.label.custom", "scale.label.custom");
        thash.put("yaxis.label.text", "scale.label.text");
        thash.put("yaxis.label.size", "scale.label.size");
        thash.put("yaxis.tick.format", "scale.tick.format");
        thash.put("yaxis.tick.size", "scale.tick.size");
        hashOfHashes.put(PanPlotType.HORZ_LINE, thash);
        hashOfHashes.put(PanPlotType.LL_ZONAL, thash);
        thash = new Hashtable();
        thash.put("xaxis.method", "scale.method");
        thash.put("xaxis.begin", "scale.min");
        thash.put("xaxis.end", "scale.max");
        thash.put("xaxis.div.major", "scale.div.major");
        thash.put("xaxis.div.minor", "scale.div.minor");
        thash.put("xaxis.label.custom", "scale.label.custom");
        thash.put("xaxis.label.text", "scale.label.text");
        thash.put("xaxis.label.size", "scale.label.size");
        thash.put("xaxis.tick.format", "scale.tick.format");
        thash.put("xaxis.tick.size", "scale.tick.size");
        hashOfHashes.put(PanPlotType.VERT_LINE, thash);
    }
}

