/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.panoply.plot.PanColorContourPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonVertPlot
extends PanColorContourPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanLonVertPlot(PanPlotMeta pmeta) {
        super(pmeta);
    }

    @Override
    protected String getXAxisLabelStr() {
        if (this.xAxisLabelText_ != null) {
            return this.xAxisLabelText_;
        }
        return "Longitude (\u00b0E)";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Object[] getXYVectorBaseAngle() {
        boolean counterclockwise;
        double baseAngleRad;
        String dir2;
        String dir1;
        block28: {
            block26: {
                block29: {
                    block27: {
                        double rBound;
                        double lBound = this.pmeta_.getDouble("xaxis.begin");
                        boolean eastAtLeft = lBound > (rBound = this.pmeta_.getDouble("xaxis.end"));
                        dir1 = this.pmeta_.getString("vector.dir1");
                        dir2 = this.pmeta_.getString("vector.dir2");
                        if (!eastAtLeft) break block26;
                        if (!dir1.equalsIgnoreCase("East")) break block27;
                        dir1 = "Left";
                        break block28;
                    }
                    if (!dir1.equalsIgnoreCase("West")) break block29;
                    dir1 = "Right";
                    break block28;
                }
                if (dir2.equalsIgnoreCase("East")) {
                    dir2 = "Left";
                    break block28;
                } else if (dir2.equalsIgnoreCase("West")) {
                    dir2 = "Right";
                }
                break block28;
            }
            if (dir1.equalsIgnoreCase("East")) {
                dir1 = "Right";
            } else if (dir1.equalsIgnoreCase("West")) {
                dir1 = "Left";
            } else if (dir2.equalsIgnoreCase("East")) {
                dir2 = "Right";
            } else if (dir2.equalsIgnoreCase("West")) {
                dir2 = "Left";
            }
        }
        if (dir2.equalsIgnoreCase("Up")) {
            baseAngleRad = 0.0;
            if (dir1.equalsIgnoreCase("Right")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Left")) {
                    LOGGER.trace("A: failed on dir1 {}, dir2 {}", (Object)dir1, (Object)dir2);
                    return null;
                }
                counterclockwise = true;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        }
        if (dir2.equalsIgnoreCase("Right")) {
            baseAngleRad = 1.5707963705062866;
            if (dir1.equalsIgnoreCase("Down")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Up")) {
                    LOGGER.trace("B: failed on dir1 {}, dir2 {}", (Object)dir1, (Object)dir2);
                    return null;
                }
                counterclockwise = true;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        }
        if (dir2.equalsIgnoreCase("Down")) {
            baseAngleRad = 3.1415927410125732;
            if (dir1.equalsIgnoreCase("Left")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Right")) {
                    LOGGER.trace("C: failed on dir1 {}, dir2 {}", (Object)dir1, (Object)dir2);
                    return null;
                }
                counterclockwise = true;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        }
        if (!dir2.equalsIgnoreCase("Left")) {
            LOGGER.trace("E failed on dir1 {}, dir2 {}", (Object)dir1, (Object)dir2);
            return null;
        }
        baseAngleRad = 4.71238899230957;
        if (dir1.equalsIgnoreCase("Up")) {
            counterclockwise = false;
            return new Object[]{baseAngleRad, counterclockwise};
        } else {
            if (!dir1.equalsIgnoreCase("Down")) {
                LOGGER.trace("D: failed on dir1 {}, dir2 {}", (Object)dir1, (Object)dir2);
                return null;
            }
            counterclockwise = true;
        }
        return new Object[]{baseAngleRad, counterclockwise};
    }
}

