/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcArrayFactory;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanPlotType;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.VariableDS;

public final class PanPlotUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static NcArray createArray(NcVariable ncvar, PanPlotType ptype) throws NcException {
        LOGGER.trace("A {}, {}", (Object)ncvar, (Object)ptype);
        return PanPlotUtils.createArray(ncvar, ptype, new Object[0]);
    }

    public static NcArray createArray(NcVariable ncvar, PanPlotType ptype, Object ... axisInfo) throws NcException {
        LOGGER.trace("B {}, {}, {}", ncvar, ptype, axisInfo);
        Objects.requireNonNull(ncvar, "Variable cannot be null.");
        Objects.requireNonNull(ptype, "Plot type cannot be null.");
        switch (ptype) {
            case LON_LAT: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.LON, NcAxisType.LAT);
            }
            case LAT_TIME: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.LAT, NcAxisType.TIME);
            }
            case LAT_VERT: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.LAT, NcAxisType.VERT);
            }
            case LON_TIME: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.LON, NcAxisType.TIME);
            }
            case LON_VERT: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.LON, NcAxisType.VERT);
            }
            case TIME_LAT: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.TIME, NcAxisType.LAT);
            }
            case TIME_VERT: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.TIME, NcAxisType.VERT);
            }
            case LL_ZONAL: {
                return NcArrayFactory.createGeoCC(ncvar, NcAxisType.LON, NcAxisType.LAT);
            }
            case LL_TRAJ: {
                return NcArrayFactory.createGeoDiscrete(ncvar);
            }
            case GENERAL_CC: {
                if (axisInfo.length < 2) {
                    throw new IllegalArgumentException("Two plot axes must be identified.");
                }
                if (axisInfo[0] == null || axisInfo[1] == null) {
                    throw new IllegalArgumentException("Axes info cannot be null.");
                }
                return NcArrayFactory.createGeneralXY(ncvar, axisInfo[0], axisInfo[1]);
            }
            case HORZ_LINE: 
            case VERT_LINE: {
                if (axisInfo.length < 1) {
                    throw new IllegalArgumentException("Plot axis must be identified.");
                }
                if (axisInfo[0] == null || axisInfo[0] instanceof Integer || axisInfo[0] instanceof NcDimension || axisInfo[0] instanceof String || axisInfo[0] instanceof VariableDS) {
                    return NcArrayFactory.create1D(ncvar, axisInfo[0]);
                }
                throw new IllegalArgumentException("Line-plot axis info is inappropriate type.");
            }
        }
        LOGGER.error("Unknown plot type, {}", (Object)ptype);
        throw new IllegalArgumentException("Unknown plot type.");
    }

    public static NcArray createCompatibleArray(NcVariable ncv, PanPlotMeta pmeta) throws NcException {
        PanPlotType plotType = pmeta.getType();
        int irank = ncv.getRank();
        if (plotType.isLonLatZonal()) {
            try {
                return PanPlotUtils.createArray(ncv, plotType);
            }
            catch (Exception exc) {
                throw new IllegalArgumentException("Second variable must be lon-lat data.");
            }
        }
        if (plotType.isLinePlot()) {
            PanData data = pmeta.getData();
            NcArray1D array1D = (NcArray1D)data.getArray(0);
            NcVariable ncv0 = (NcVariable)array1D.getNcObject();
            int idx = array1D.getDimensionIndex();
            NcDimension dim = ncv0.getNcDimension(idx);
            for (int i = 0; i < irank; ++i) {
                NcDimension adim = ncv.getNcDimension(i);
                if (!adim.equals(dim)) continue;
                return PanPlotUtils.createArray(ncv, plotType, i);
            }
            throw new IllegalArgumentException("Second variable must have a dimension identical to that of the plot axis.");
        }
        if (plotType.isGeoreferenced()) {
            try {
                return PanPlotUtils.createArray(ncv, plotType);
            }
            catch (Exception exc) {
                throw new IllegalArgumentException("Second variable must have two dimensions compatible with those of the plot.");
            }
        }
        if (irank < 2) {
            throw new IllegalArgumentException("Second variable must have at least two dimensions.");
        }
        if (plotType == PanPlotType.GENERAL_CC) {
            PanData data = pmeta.getData();
            NcArray2D array2D = (NcArray2D)data.getArray(0);
            NcVariable ncv0 = (NcVariable)array2D.getNcObject();
            int xidx = array2D.getXDimensionIndex();
            int yidx = array2D.getYDimensionIndex();
            NcDimension xdim = ncv0.getNcDimension(xidx);
            NcDimension ydim = ncv0.getNcDimension(yidx);
            int xidx2 = -1;
            int yidx2 = -1;
            for (int i = 0; i < irank; ++i) {
                NcDimension adim = ncv.getNcDimension(i);
                if (adim.equals(xdim)) {
                    xidx2 = i;
                    continue;
                }
                if (!adim.equals(ydim)) continue;
                yidx2 = i;
            }
            if (xidx2 > -1 && yidx2 > -1) {
                return PanPlotUtils.createArray(ncv, plotType, xidx2, yidx2);
            }
            throw new IllegalArgumentException("Second variable must have two dimensions identical to those of the plot axes.");
        }
        return null;
    }

    private PanPlotUtils() {
    }
}

