/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.StringComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonVertPrefsPanel
extends PanAbstractPrefsPanel {
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private GTextField lvalTF_;
    private GTextField rvalTF_;
    private DescribedEnumComboBox yMethodCombo_;
    private StringComboBox yFormatCombo_;
    private boolean refreshing_;

    public PanLonVertPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Vert Plots"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a lon-vert plot, set\u2026");
        this.lvalTF_ = GTextField.createDoubleField(-180.0);
        this.rvalTF_ = GTextField.createDoubleField(180.0);
        this.yMethodCombo_ = new DescribedEnumComboBox(PanAxisMethod.class);
        this.yFormatCombo_ = StringComboBox.createNumberPformat();
        GuiUtils.applyComboBoxUI(this.yFormatCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 5, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, 1));
        this.add((Component)new JLabel("Lon Axis Left:\u2009"), new FGConstraint(0, 2, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.lvalTF_, new JLabel("\u00b0E, Right "), this.rvalTF_, new JLabel("\u00b0E")), new FGConstraint(1, 2));
        this.add((Component)new JLabel("Vert Axis Units:\u2009"), new FGConstraint(0, 3, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.yMethodCombo_, new JLabel("\u2014 Format:\u2009"), this.yFormatCombo_), new FGConstraint(1, 3));
        this.yMethodCombo_.setMaximumSize(this.yMethodCombo_.getPreferredSize());
        this.yFormatCombo_.setMaximumSize(this.yFormatCombo_.getPreferredSize());
    }

    private void attachListeners() {
        FocusAdapter xRangeFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonVertPrefsPanel.this.handleXExtrema(e);
            }
        };
        ActionListener xRangeAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanLonVertPrefsPanel.this.handleXExtrema(e);
            }
        };
        this.lvalTF_.addFocusListener(xRangeFL);
        this.rvalTF_.addFocusListener(xRangeFL);
        this.lvalTF_.addActionListener(xRangeAL);
        this.rvalTF_.addActionListener(xRangeAL);
        this.yMethodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:lonvert.yaxis.method", this.yMethodCombo_.getEnumName());
        });
        this.yFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:lonvert.yaxis.tick.format", this.yFormatCombo_.getSelectedString());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.lvalTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:lonvert.xaxis.begin")));
        this.rvalTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:lonvert.xaxis.end")));
        this.yFormatCombo_.setSelectedItem(prefs_.getString("plot:lonvert.yaxis.tick.format"));
        this.yMethodCombo_.setSelItemMatching(prefs_.getString("plot:lonvert.yaxis.method"));
        this.refreshing_ = false;
    }

    private void handleXExtrema(EventObject e) {
        double oldright;
        double oldleft;
        double left = oldleft = prefs_.getDouble("plot:lonvert.xaxis.begin");
        try {
            left = StringUtils.parseDouble(this.lvalTF_.getText());
        }
        catch (Exception exc) {
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(oldleft));
            return;
        }
        if (left < -360.0) {
            left = -360.0;
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
        } else if (left >= 360.0) {
            left = 360.0;
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
        }
        double right = oldright = prefs_.getDouble("plot:lonvert.xaxis.end");
        try {
            right = StringUtils.parseDouble(this.rvalTF_.getText());
        }
        catch (Exception exc) {
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(oldright));
            return;
        }
        if (right < -360.0) {
            right = -360.0;
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
        } else if (right >= 360.0) {
            right = 360.0;
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
        }
        if (left == right) {
            if (left <= 0.0) {
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right += -360.0));
            } else {
                this.lvalTF_.setText(PFORMAT_7G.sprintfx(left -= -360.0));
            }
        } else if (Math.abs(right - left) > 360.0) {
            boolean pright;
            boolean bl = pright = right - left > 0.0;
            if (e == null) {
                right = pright ? left + 360.0 : left - 360.0;
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
            } else if (e.getSource() == this.lvalTF_) {
                right = pright ? left + 360.0 : left - 360.0;
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
            } else if (e.getSource() == this.rvalTF_) {
                left = pright ? right - 360.0 : right + 360.0;
                this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
            }
        }
        prefs_.setDouble("plot:lonvert.xaxis.begin", left);
        prefs_.setDouble("plot:lonvert.xaxis.end", right);
    }
}

