/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefs.PanSavedSettings;
import gov.nasa.giss.panoply.prefs.PanSavedSettingsHandler;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTablePanel;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableScrollPane;
import gov.nasa.giss.panoply.prefsui.PanSavedSettingsTableModel;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import net.schmunk.ui.PlusMinus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSavedSettingsPrefsPanel
extends PanCommonPrefsTablePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean refreshing_;

    @Override
    void createLayout() {
        TableCellRenderer tcr;
        Serializable c;
        this.setBorder(GuiUtils.createPaddedTitleBorder("Saved Settings"));
        this.setOpaque(false);
        this.tmodel_ = new PanSavedSettingsTableModel();
        this.table_ = new PanCommonPrefsTable(this.tmodel_);
        this.tspane_ = new PanPrefsTableScrollPane(this.table_);
        TableColumnModel tcm = this.table_.getColumnModel();
        int ccount = tcm.getColumnCount();
        for (int i = 0; i < ccount; ++i) {
            c = this.tmodel_.getColumnClass(i);
            if (!c.equals(String.class)) continue;
            DefaultTableCellRenderer tcr2 = new DefaultTableCellRenderer();
            tcr2.setHorizontalAlignment(((PanSavedSettingsTableModel)this.tmodel_).getColumnAlignment(i));
            tcm.getColumn(i).setCellRenderer(tcr2);
        }
        try {
            tcr = this.table_.getCellRenderer(0, 0);
            c = tcr.getTableCellRendererComponent(this.table_, "GENERAL_CC", false, false, 0, 0);
            int ww = ((Component)c).getPreferredSize().width + 12;
            tcm.getColumn(0).setMinWidth(ww);
        }
        catch (Exception exc) {
            tcm.getColumn(0).setMinWidth(Math.max(100, tcm.getColumn(2).getPreferredWidth()));
        }
        tcm.getColumn(1).setPreferredWidth(500);
        try {
            tcr = this.table_.getCellRenderer(0, 2);
            c = tcr.getTableCellRendererComponent(this.table_, "2019-12-31", false, false, 0, 2);
            int ww = ((Component)c).getPreferredSize().width + 12;
            tcm.getColumn(2).setMinWidth(ww);
        }
        catch (Exception exc) {
            tcm.getColumn(2).setMinWidth(Math.max(90, tcm.getColumn(2).getPreferredWidth()));
        }
        this.pmwidget_ = new PlusMinus();
        this.pmwidget_.setMaximumSize(this.pmwidget_.getPreferredSize());
        this.pmwidget_.setPlusEnabled(false);
        this.pmwidget_.setMinusEnabled(false);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 2, 12, 2);
        fgl.setRowWeight(0, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)this.tspane_, new FGConstraint(0, 0, 2, 1, true));
        this.add((Component)this.pmwidget_, new FGConstraint(0, 1));
    }

    @Override
    void displaySelection(int index) {
    }

    @Override
    void additionRequested() {
    }

    @Override
    void deletionRequested(int index) {
        this.table_.clearSelection();
        PanSavedSettings pss = ((PanSavedSettingsTableModel)this.tmodel_).getSettings(index);
        PanSavedSettingsHandler.getSharedInstance().remove(pss);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
        this.table_.repaint();
        GuiUtils.refreshFrontFrameMenuBar();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        int row = this.table_.getSelectedRow();
        if (row < 0 || row >= this.tmodel_.getRowCount()) {
            this.pmwidget_.setMinusEnabled(false);
        } else {
            this.pmwidget_.setMinusEnabled(true);
        }
    }
}

