/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarkNode;
import gov.nasa.giss.panoply.sources.PanBookmarkTreeTablePanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmarksPanel
extends PanSourcesPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanBookmarksPanel(PanSourcesFrame parent) {
        super(parent, false);
    }

    @Override
    protected JComponent makeTreeHolder() {
        this.ttPanel_ = new PanBookmarkTreeTablePanel();
        this.ttPanel_.addTreeTableListener(this);
        return this.ttPanel_;
    }

    @Override
    synchronized void refreshActions() {
        PanActionHash actionHash = this.parent_.getActionHash();
        boolean animating = PanPlotFrame.isAnimationInProgress();
        actionHash.disableAll();
        if (this.ttPanel_.getModel().getRowCount() > 0) {
            actionHash.setEnabled("find", true);
            actionHash.setEnabled("find-next", true);
        } else {
            actionHash.setEnabled("find", this.isFindVisible());
        }
        TreeTableNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (node instanceof PanBookmark) {
            actionHash.setEnabled("open-source", !animating);
        }
    }

    @Override
    protected void refreshInfoPane() {
    }

    @Override
    public void clear() {
    }

    public PanBookmarkNode addNode(PanBookmarkNode node) {
        if (node == null) {
            return null;
        }
        return ((PanBookmarkTreeTablePanel)this.ttPanel_).addNode(node);
    }

    @Override
    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        ((PanBookmarkTreeTablePanel)this.ttPanel_).removeNode(node);
        this.refreshActions();
        this.refreshInfoPane();
    }

    @Override
    public void selectionMade(TreeTableEvent e) {
        this.refreshActions();
        this.refreshInfoPane();
        TreeTableNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        int id = e.getID();
        if (id == 102 && node instanceof PanBookmark) {
            ((PanBookmark)node).open(this.parent_);
        }
    }

    @Override
    public void itemAdded(TreeTableEvent e) {
    }
}

