/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.util.PanLLGridSpacing;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import javax.swing.JComboBox;

public final class PanLLGridSpacingComboBox
extends JComboBox<PanLLGridSpacing> {
    private PanLLGridSpacingComboBox(SizeVariant size, String name) {
        for (PanLLGridSpacing item : PanLLGridSpacing.DEFAULT_CHOICES) {
            this.addItem(item);
        }
        if (name != null) {
            this.setName(name);
        }
        GuiUtils.applyComboBoxUI(this, size);
    }

    public static PanLLGridSpacingComboBox create(String name) {
        return new PanLLGridSpacingComboBox(SizeVariant.REGULAR, name);
    }

    public static PanLLGridSpacingComboBox small(String name) {
        return new PanLLGridSpacingComboBox(SizeVariant.SMALL, name);
    }

    @Override
    public void setSelectedItem(Object item) {
        PanLLGridSpacing gs;
        int i;
        if (item == null) {
            super.setSelectedItem(PanLLGridSpacing.NONE);
            return;
        }
        if (item instanceof PanLLGridSpacing) {
            super.setSelectedItem(item);
            return;
        }
        int isize = this.getItemCount();
        if (item instanceof Float) {
            float d = ((Float)item).floatValue();
            for (i = 0; i < isize; ++i) {
                gs = (PanLLGridSpacing)this.getItemAt(i);
                if (!((double)Math.abs(gs.getSpacing() - d) < 1.0E-5)) continue;
                super.setSelectedItem(gs);
                return;
            }
        }
        String s = item.toString();
        for (i = 0; i < isize; ++i) {
            gs = (PanLLGridSpacing)this.getItemAt(i);
            if (!gs.toString().equals(s)) continue;
            super.setSelectedItem(gs);
            return;
        }
    }

    public void setSelectedItem(float spacing) {
        this.setSpacing(spacing);
    }

    public void setSpacing(float spacing) {
        if (spacing <= 0.0f) {
            super.setSelectedItem(PanLLGridSpacing.NONE);
            return;
        }
        this.setSelectedItem(Float.valueOf(spacing));
    }

    public float getSpacing() {
        PanLLGridSpacing gs = (PanLLGridSpacing)this.getItemAt(this.getSelectedIndex());
        return gs.getSpacing();
    }
}

