/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import javax.swing.JComboBox;

public final class PanOverlayComboBox
extends JComboBox<String>
implements ResourceListDataListener {
    private static final String NONE = "None";
    private final boolean hiliteFaves_ = true;
    private boolean refreshing_;
    private boolean firstIsNone_;

    private PanOverlayComboBox(boolean includeNone) {
        this(SizeVariant.REGULAR, includeNone);
    }

    private PanOverlayComboBox(SizeVariant size, boolean includeNone) {
        this.firstIsNone_ = includeNone;
        this.refresh();
        this.setSelectedIndex(0);
        GuiUtils.applyComboBoxUI(this, size);
        PanResourceUtils.getOverlayList().addListDataListener(this);
    }

    public boolean isRefreshing() {
        return this.refreshing_;
    }

    private void refresh() {
        MapOverlay newItem;
        int i;
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        Object selItem = this.getSelectedItem();
        this.removeAllItems();
        if (this.firstIsNone_) {
            this.addItem(NONE);
            this.addItem(null);
        }
        OverlayResourceList reslist = PanResourceUtils.getOverlayList();
        int isize = reslist.getSize();
        boolean skippedOne = false;
        for (i = 0; i < isize; ++i) {
            if (!reslist.isFavorite(i)) {
                skippedOne = true;
                continue;
            }
            newItem = PanResourceUtils.getOverlay(i);
            if (newItem == null) continue;
            this.addItem(((Object)newItem).toString());
        }
        if (skippedOne) {
            this.addItem(null);
            for (i = 0; i < isize; ++i) {
                if (reslist.isFavorite(i) || (newItem = PanResourceUtils.getOverlay(i)) == null) continue;
                this.addItem(((Object)newItem).toString());
            }
        }
        if (selItem != null) {
            this.setSelectedItem(selItem);
        }
        this.refreshing_ = false;
    }

    public MapOverlay getSelectedOverlay() {
        Object item = this.getSelectedItem();
        if (item == null) {
            return null;
        }
        return PanResourceUtils.getOverlay((String)item);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        this.refresh();
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
        this.refresh();
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        this.refresh();
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanOverlayComboBox panOverlayComboBox = this;
        synchronized (panOverlayComboBox) {
            PanResourceUtils.getOverlayList().removeListDataListener(this);
            this.removeAll();
        }
    }

    public static PanOverlayComboBox create(boolean includeNone) {
        return new PanOverlayComboBox(SizeVariant.REGULAR, includeNone);
    }

    public static PanOverlayComboBox create(String name, boolean includeNone) {
        PanOverlayComboBox result = PanOverlayComboBox.create(includeNone);
        if (name != null) {
            result.setName(name);
        }
        return result;
    }

    public static PanOverlayComboBox small(boolean includeNone) {
        return new PanOverlayComboBox(SizeVariant.SMALL, includeNone);
    }

    public static PanOverlayComboBox small(String name, boolean includeNone) {
        PanOverlayComboBox result = PanOverlayComboBox.small(includeNone);
        if (name != null) {
            result.setName(name);
        }
        return result;
    }
}

