/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import javax.swing.JComboBox;

public class PanUnderlayComboBox
extends JComboBox<String>
implements ResourceListDataListener {
    private static final String NONE = "None";
    private static KMLDataResourceList kmlList_ = PanResourceUtils.getUnderlayList();
    private final boolean firstIsNone_ = true;

    public PanUnderlayComboBox(SizeVariant size) {
        this.addItem(NONE);
        this.addItem(null);
        int isize = kmlList_.getSize();
        for (int i = 0; i < isize; ++i) {
            Object newItem = kmlList_.getBackingObject(i);
            if (newItem == null) continue;
            this.addItem(newItem.toString());
        }
        this.setMaximumSize(this.getPreferredSize());
        GuiUtils.applyComboBoxUI(this, size);
        kmlList_.addListDataListener(this);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item.toString());
        }
    }

    public void setSelectedItem(KMLData item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item.toString());
        }
    }

    public KMLData getSelectedUnderlay() {
        String item = (String)this.getSelectedItem();
        if (item == null) {
            return null;
        }
        return PanResourceUtils.getUnderlay(item);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        boolean offset = true;
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        for (int i = index0; i <= index1; ++i) {
            KMLData oo = PanResourceUtils.getUnderlay(i);
            if (oo == null) continue;
            this.insertItemAt(((Object)oo).toString(), i + 1);
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index1;
        boolean offset = true;
        int index = this.getSelectedIndex();
        int index0 = e.getIndex0();
        for (int i = index1 = e.getIndex1(); i >= index0; --i) {
            this.removeItemAt(i + 1);
        }
        if (index >= index0 + 1 && index <= index1 + 1) {
            if (index0 > 0) {
                this.setSelectedIndex(index0 - 1 + 1);
            } else {
                this.setSelectedIndex(index0 + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanUnderlayComboBox panUnderlayComboBox = this;
        synchronized (panUnderlayComboBox) {
            kmlList_.removeListDataListener(this);
            this.removeAll();
        }
    }
}

