/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.JDCalendar;
import gov.nasa.giss.time.UTParser;
import gov.nasa.giss.time.mission.MarsLanderTime;
import gov.nasa.giss.time.mission.MissionStatus;
import gov.nasa.giss.time.planet.MarsTime;
import java.util.Date;

public class MarsPhoenix
extends MarsLanderTime {
    private static final String LAUNCH_STRING = "2007-08-04 09:26:34";
    private static final String SOL0_STRING = "2008-05-25 06:51:20";
    private static final String LANDING_STRING = "2008-05-25 23:38:35";
    private static final long LAUNCH_MILLIS;
    private static final long SOL0_MILLIS;
    private static final long DESCENT_MILLIS;
    private static final long LANDING_MILLIS;

    public MarsPhoenix() {
        super("Mars Phoenix");
    }

    public MarsPhoenix(MarsTime marsTime) {
        this();
        this.setPlanetTime(marsTime);
    }

    @Override
    protected void update() {
        long millis = this.mTime_.getMillis();
        if (millis < LAUNCH_MILLIS) {
            this.status_ = MissionStatus.NOT_LAUNCHED;
            this.sol_ = Long.MIN_VALUE;
            this.fraction_ = 0.0;
        } else {
            double lltSec = (double)(millis - SOL0_MILLIS) * 0.001 * 0.9732442960905843;
            double llt = lltSec * 1.1574074074074073E-5;
            this.sol_ = (long)Math.floor(llt);
            this.fraction_ = llt - (double)this.sol_;
            this.status_ = millis < DESCENT_MILLIS ? MissionStatus.IN_FLIGHT : (millis < LANDING_MILLIS ? MissionStatus.DESCENDING : MissionStatus.ACTIVE);
        }
        this.needsUpdate_ = false;
    }

    public long timeToLanding() {
        long millis = this.mTime_.getMillis();
        return LANDING_MILLIS - millis;
    }

    static {
        Date launchDate = UTParser.parse(LAUNCH_STRING);
        Date sol0Date = UTParser.parse(SOL0_STRING);
        Date landingDate = UTParser.parse(LANDING_STRING);
        JDCalendar jdc = new JDCalendar();
        jdc.setTime(launchDate);
        LAUNCH_MILLIS = jdc.getTimeInMillis();
        jdc.setTime(sol0Date);
        SOL0_MILLIS = jdc.getTimeInMillis();
        jdc.setTime(landingDate);
        LANDING_MILLIS = jdc.getTimeInMillis();
        DESCENT_MILLIS = LANDING_MILLIS - 420000L;
    }
}

