/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.plaf.GissComboBoxUI;
import gov.nasa.giss.util.DescribedItem;
import javax.swing.JComboBox;

public class DescribedEnumComboBox
extends JComboBox<DescribedItem> {
    public DescribedEnumComboBox(Class<? extends DescribedItem> ee) {
        if (ee.isEnum()) {
            DescribedItem[] vals = ee.getEnumConstants();
            if (vals != null && vals.length > 0) {
                for (DescribedItem o : vals) {
                    this.addItem(o);
                }
            }
        } else {
            throw new IllegalArgumentException(ee.getSimpleName() + " is not an enum class");
        }
        this.setUI(new GissComboBoxUI());
    }

    @Override
    public void setEditable(boolean aFlag) {
    }

    public String getEnumName() {
        int idx = this.getSelectedIndex();
        DescribedItem item = (DescribedItem)this.getItemAt(idx);
        return item.name();
    }

    @Deprecated
    public void setSelectedItem(String s) {
        this.setSelItemMatching(s);
    }

    public void setSelItemMatching(String s) {
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            DescribedItem ditem = (DescribedItem)this.getItemAt(i);
            if (!ditem.matches(s)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }
}

