/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.treetable;

import gov.nasa.giss.ui.treetable.TreeTable;
import gov.nasa.giss.ui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import gov.nasa.giss.ui.treetable.TreeTableTextField;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private final TreeTable ttable_;
    private final TreeTableCellRenderer renderer_;

    public TreeTableCellEditor(TreeTable ttable, TreeTableCellRenderer renderer) {
        super(new TreeTableTextField());
        this.ttable_ = ttable;
        this.renderer_ = renderer;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, col);
        TreeTableModel tmodel = this.ttable_.getTreeTableModel();
        TreeTableNode node = tmodel.getNodeForRow(row);
        int textX = this.renderer_.getTextX(this.ttable_, node, null);
        ((TreeTableTextField)this.getComponent()).setOffset(textX);
        return component;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (!(e instanceof MouseEvent)) {
            return false;
        }
        MouseEvent me = (MouseEvent)e;
        if (me.getButton() != 1) {
            return false;
        }
        TreeTableNode node = this.ttable_.getNodeForPoint(me.getPoint());
        if (node == null) {
            return false;
        }
        int x = me.getX();
        int isize = this.ttable_.getColumnCount();
        TreeTableModel model = this.ttable_.getTreeTableModel();
        int modifiers = me.getModifiers();
        for (int col = 0; col < isize; ++col) {
            if (this.ttable_.getColumnClass(col) != TreeTableModel.class) continue;
            int discloseX = this.renderer_.getDisclosureX(this.ttable_, node, null);
            int iconX = this.renderer_.getIconX(this.ttable_, node, null);
            if (modifiers == 16) {
                if (!node.getAllowsChildren()) break;
                if (x < discloseX) continue;
                if (x >= iconX && me.getClickCount() <= 1) break;
                model.toggleNode(node);
                break;
            }
            if (modifiers != 24 || !node.isEditable() || x <= iconX) break;
            return true;
        }
        return false;
    }
}

