/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util.reslist;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.JarUtils;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import gov.nasa.giss.util.reslist.ResourceListEntry;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final EntryComparator FS_COMPARATOR = new EntryComparator();
    private final FilenameFilter ffilter_;
    private static boolean supportDirDisabled_;
    private boolean supportDirFailed_;
    private boolean supportDirScanned_;
    private final ArrayList<ResourceListEntry> internalList_;
    private final ArrayList<ResourceListDataListener> listeners_;

    protected ResourceList(FilenameFilter ff) {
        this.ffilter_ = ff;
        this.internalList_ = new ArrayList(50);
        this.listeners_ = new ArrayList(24);
    }

    public void scanJarDirectory(ResourceList o, String dirName) {
        if (o == null) {
            return;
        }
        this.scanJarDirectory(o.getClass(), dirName);
    }

    public void scanJarDirectory(Class<?> c, String dirName) {
        String[] fnames;
        block8: {
            fnames = null;
            try {
                fnames = JarUtils.getResourceListing(c, dirName);
            }
            catch (Exception exc) {
                LOGGER.info("Exception scanning resource jar directory: {}", (Object)exc.toString());
                if (!LOGGER.isDebugEnabled()) break block8;
                exc.printStackTrace();
            }
        }
        if (fnames != null) {
            for (String s : fnames) {
                try {
                    String where = dirName + "/" + s;
                    URL url = c.getResource(where);
                    if (url == null) {
                        LOGGER.info("No resource at {}", (Object)where);
                        continue;
                    }
                    this.addToArrayList(null, ResourceListEntry.LocType.JAR, url, null);
                }
                catch (Exception exc) {
                    LOGGER.info("Could not open resource {} due to {}", (Object)s, (Object)exc.toString());
                    if (LOGGER.isDebugEnabled()) {
                        exc.printStackTrace();
                    }
                    System.exit(1);
                }
            }
        }
    }

    public static void disableAppSupportDirectory() {
        supportDirDisabled_ = true;
    }

    protected void scanAppSupportDirectory(String dirName) {
        if (supportDirDisabled_) {
            this.supportDirFailed_ = true;
            return;
        }
        if (this.supportDirFailed_) {
            LOGGER.warn("Previously tried to access support dir {} but failed", (Object)dirName);
            return;
        }
        if (this.supportDirScanned_) {
            LOGGER.warn("Support directory {} already scanned", (Object)dirName);
            return;
        }
        File supportDir = null;
        try {
            supportDir = this.findAppSupportDirectory(dirName);
        }
        catch (Exception exc) {
            this.supportDirFailed_ = true;
            LOGGER.warn("Failed finding support directory: {}", (Object)dirName);
            return;
        }
        if (this.supportDirFailed_ || supportDir == null) {
            return;
        }
        if (!supportDir.exists() && !supportDir.isDirectory()) {
            return;
        }
        for (File file : supportDir.listFiles(this.ffilter_)) {
            if (file.isDirectory() || file.getName().startsWith(".")) continue;
            try {
                this.addToArrayList(null, ResourceListEntry.LocType.USERLIB, file, null);
            }
            catch (Exception exc) {
                LOGGER.info("Exception scanning support directory: {}", (Object)dirName);
                LOGGER.info("Exception occurred with file: {}", (Object)file.getName());
                LOGGER.info("Exception was: {}", (Object)exc.getMessage());
                if (!LOGGER.isDebugEnabled()) continue;
                exc.printStackTrace();
            }
        }
        this.supportDirScanned_ = true;
    }

    private File findAppSupportDirectory(String dirName) {
        if (this.supportDirFailed_) {
            return null;
        }
        Objects.requireNonNull(dirName, "Resource directory name cannot be null.");
        if (dirName.isEmpty()) {
            throw new IllegalArgumentException("Empty resource directory name.");
        }
        File gissSupportDir = FileUtils.getGISSAppSupportDirectory();
        File supportDir = new File(gissSupportDir, dirName);
        if (supportDir == null) {
            return null;
        }
        if (!supportDir.exists()) {
            boolean created = supportDir.mkdirs();
            if (!created) {
                LOGGER.warn("Unable to create path for support dir {}", (Object)dirName);
                this.supportDirFailed_ = true;
                return null;
            }
        } else if (!supportDir.isDirectory()) {
            LOGGER.warn("Support address {} exists but is not a directory", (Object)dirName);
            this.supportDirFailed_ = true;
            return null;
        }
        return supportDir;
    }

    public abstract String getResourceDescription();

    public abstract String getResourceDescriptionPlural();

    public abstract String getAppSupportDirectoryName();

    public int getSize() {
        return this.internalList_.size();
    }

    public ResourceListEntry getElementAt(int index) {
        if (index < 0 || index >= this.internalList_.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range");
        }
        return this.internalList_.get(index);
    }

    public ResourceListEntry getElement(String name) {
        Objects.requireNonNull(name, "Resource name cannot be null.");
        for (ResourceListEntry ii : this.internalList_) {
            if (!name.equalsIgnoreCase(ii.getName())) continue;
            return ii;
        }
        return null;
    }

    public Object getBackingObject(int index) {
        ResourceListEntry ee = this.getElementAt(index);
        return ee.getObject();
    }

    public Object getBackingObject(String name) {
        if (name == null) {
            LOGGER.warn("Specified resource name is null.");
        }
        for (ResourceListEntry ii : this.internalList_) {
            if (!name.equalsIgnoreCase(ii.getName())) continue;
            return ii.getObject();
        }
        return null;
    }

    public String getName(int index) {
        ResourceListEntry ee = this.getElementAt(index);
        return ee.getName();
    }

    public boolean isFavorite(int index) {
        ResourceListEntry ee = this.getElementAt(index);
        return ee.isFavorite();
    }

    public void setFavorite(int index, boolean fave) {
        ResourceListEntry ee = this.getElementAt(index);
        ee.setFavorite(fave);
        this.fireStatusChanged(index);
    }

    public ResourceListEntry.LocType getLocType(int index) {
        ResourceListEntry ee = this.getElementAt(index);
        return ee.getLocType();
    }

    public Object[] addAlphabetic(ArrayList<File> flist) {
        if (flist.isEmpty()) {
            return null;
        }
        return this.addAlphabetic(flist.toArray(new File[0]));
    }

    public Object[] addAlphabetic(File ... files) {
        JFrame jff = null;
        if (!PlatformUtils.isHeadless() && (jff = GuiUtils.getActiveFrame()) == null) {
            jff = new JFrame();
        }
        return this.addAlphabetic((Component)jff, files);
    }

    public Object[] addAlphabetic(Component source, ArrayList<File> flist) {
        if (flist.isEmpty()) {
            return null;
        }
        return this.addAlphabetic(source, flist.toArray(new File[0]));
    }

    public Object[] addAlphabetic(Component source, File ... files) {
        if (source == null) {
            return this.addAlphabetic(null, false, files);
        }
        return this.addAlphabeticQuery(source, files);
    }

    private Object[] addAlphabeticQuery(Component source, File ... files) {
        Object[] options = new String[]{"Import", "No"};
        String description = files.length > 1 ? this.getResourceDescriptionPlural() : this.getResourceDescription();
        int choice = JOptionPane.showOptionDialog(source, "Should I import the " + description + " into your support\nlibrary for future use?", "Library", 0, 3, null, options, 0);
        boolean importToLib = choice == 0;
        return this.addAlphabetic(source, importToLib, files);
    }

    public Object[] addAlphabetic(Component source, boolean importToLib, File ... files) {
        ArrayList<Object> added = new ArrayList<Object>();
        for (File f : files) {
            String fname = f.getName();
            if (this.getElement(fname) != null) {
                String already = "There is already a " + this.getResourceDescription() + " in the support library named " + fname + ".";
                if (source == null) {
                    LOGGER.warn("{}. Skipping.", (Object)already);
                    continue;
                }
                if (files.length > 1) {
                    boolean skip;
                    Object[] options = new String[]{"Okay", "Stop"};
                    int choice = JOptionPane.showOptionDialog(source, already + " Should I skip over it?", "Library", 0, 3, null, options, 0);
                    boolean bl = skip = choice == 0;
                    if (!skip) break;
                    continue;
                }
                JOptionPane.showMessageDialog(source, already, "Library", 1);
                continue;
            }
            Object o = null;
            try {
                o = this.createObject(f);
            }
            catch (Exception exc) {
                if (source == null) {
                    LOGGER.warn("Could not open {} {}.", (Object)this.getResourceDescription(), (Object)fname);
                    LOGGER.warn("Message is {}", (Object)exc.toString());
                }
                String msg = exc.toString().replaceFirst(".*Exception: ", "");
                FileUtils.showFileError(source, fname, msg);
            }
            if (o != null) {
                if (importToLib) {
                    File xf = this.copyToAppSupportDirectory(source, f, this.getAppSupportDirectoryName(), false);
                    if (xf != null) {
                        this.addToArrayList(source, ResourceListEntry.LocType.USERLIB, xf, o);
                    }
                } else {
                    this.addToArrayList(source, ResourceListEntry.LocType.OTHER, f, o);
                }
            }
            if (o == null) continue;
            added.add(o);
        }
        return added.toArray(new Object[0]);
    }

    private Object addToArrayList(Component source, ResourceListEntry.LocType loctype, Object address, Object o) {
        Objects.requireNonNull(address, "Address cannot be null.");
        ResourceListEntry info = this.createSetEntry(loctype, address, o);
        int isize = this.getSize();
        for (int i = 0; i < isize; ++i) {
            int compare = FS_COMPARATOR.compare(info, this.getElementAt(i));
            if (compare == 0) {
                return this.getBackingObject(i);
            }
            if (compare >= 0) continue;
            this.internalList_.add(i, info);
            this.fireIntervalAdded(source, i);
            return o;
        }
        this.internalList_.add(info);
        this.fireIntervalAdded(source, isize);
        return o;
    }

    protected abstract Object createObject(File var1);

    protected abstract ResourceListEntry createSetEntry(ResourceListEntry.LocType var1, Object var2, Object var3);

    public Object[] toArray() {
        int isize = this.internalList_.size();
        Object[] result = new Object[isize];
        for (int i = 0; i < isize; ++i) {
            result[i] = this.getBackingObject(i);
        }
        return result;
    }

    public String[] getNames() {
        int isize = this.internalList_.size();
        String[] result = new String[isize];
        for (int i = 0; i < isize; ++i) {
            result[i] = this.getName(i);
        }
        return result;
    }

    public boolean canRemove(int index) {
        ResourceListEntry.LocType loctype = this.getLocType(index);
        if (loctype == null) {
            return false;
        }
        return loctype == ResourceListEntry.LocType.USERLIB || loctype == ResourceListEntry.LocType.OTHER;
    }

    public Object remove(int index) {
        ResourceListEntry info;
        block7: {
            if (index < 0 || index >= this.internalList_.size()) {
                throw new IndexOutOfBoundsException("Index " + index + " out of range");
            }
            LOGGER.trace("removing {}", (Object)index);
            info = this.internalList_.remove(index);
            this.fireIntervalRemoved(null, index);
            ResourceListEntry.LocType grp = info.getLocType();
            if (grp == ResourceListEntry.LocType.USERLIB) {
                try {
                    File f = (File)info.getAddress();
                    if (f.exists()) {
                        f.delete();
                    }
                }
                catch (Exception exc) {
                    LOGGER.trace("Failed to delete resource item: {}", (Object)exc.toString());
                    if (!LOGGER.isDebugEnabled()) break block7;
                    exc.printStackTrace();
                }
            }
        }
        try {
            return info.getObject();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void printList() {
        for (ResourceListEntry ii : this.internalList_) {
            System.out.println(ii.toString());
        }
    }

    private File copyToAppSupportDirectory(Component source, File input, String outputDirName, boolean overwrite) {
        if (this.supportDirFailed_) {
            LOGGER.trace("Cannot save resource to library because we do not have access.");
            return null;
        }
        try {
            return this.copyToAppSupportDirectory(input, outputDirName, overwrite);
        }
        catch (Exception exc) {
            if (source != null && exc.toString().contains("already exists")) {
                SlowMessage.show(source, "Library Error", "There is already a resource by that name in the support directory.");
            } else if (exc.toString().contains("already exists")) {
                LOGGER.debug("There is already a resource by that name in the library.");
            } else {
                LOGGER.debug("Could not save resource to library: {}", (Object)exc.toString());
            }
            return null;
        }
    }

    private File copyToAppSupportDirectory(File input, String outputDirName, boolean overwrite) throws IOException {
        if (this.supportDirFailed_) {
            LOGGER.debug("Cannot save resource to library because we do not have access.");
            return null;
        }
        File appSupport = null;
        try {
            appSupport = this.findAppSupportDirectory(outputDirName);
        }
        catch (Exception exc) {
            return null;
        }
        if (appSupport == null) {
            return null;
        }
        if (!appSupport.exists()) {
            return null;
        }
        if (!appSupport.isDirectory()) {
            return null;
        }
        Objects.requireNonNull(input, "Resource file cannot be null.");
        if (!input.isFile()) {
            throw new IllegalArgumentException("Input is not a file.");
        }
        String name = input.getName();
        File output = new File(appSupport, name);
        if (output.exists() && !overwrite) {
            throw new IOException("Resource by that name already exists in the support directory");
        }
        try (FileInputStream fis = new FileInputStream(input);
             FileOutputStream fos = new FileOutputStream(output);
             FileChannel inputChannel = fis.getChannel();
             FileChannel outputChannel = fos.getChannel();){
            outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ResourceListDataListener ll) {
        ArrayList<ResourceListDataListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.add(ll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ResourceListDataListener ll) {
        ArrayList<ResourceListDataListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.remove(ll);
        }
    }

    public synchronized void removeListDataListeners() {
        this.listeners_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIntervalAdded(Component component, int index) {
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 1, index, index);
        ArrayList<ResourceListDataListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).intervalAdded(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIntervalRemoved(Component component, int index) {
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 2, index, index);
        ArrayList<ResourceListDataListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).intervalRemoved(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStatusChanged(int index) {
        ResourceListDataEvent e = new ResourceListDataEvent(this, null, 3, index, index);
        ArrayList<ResourceListDataListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).statusChanged(e);
                }
            }
        }
    }

    private /* synthetic */ void lambda$addAlphabetic$0(Component source, File[] files) {
        this.addAlphabeticQuery(source, files);
        if (source instanceof JFrame) {
            JFrame jf = (JFrame)source;
            jf.setExtendedState(0);
            jf.toFront();
            jf.requestFocus();
            WindowListener[] wll = jf.getWindowListeners();
            if (wll.length > 0) {
                wll[0].windowActivated(new WindowEvent(jf, 205));
            }
        }
    }

    protected static class EntryComparator
    implements Comparator<ResourceListEntry> {
        private final Collator collator_ = Collator.getInstance();

        protected EntryComparator() {
        }

        @Override
        public int compare(ResourceListEntry o1, ResourceListEntry o2) {
            CollationKey k1 = this.collator_.getCollationKey(o1.toString());
            CollationKey k2 = this.collator_.getCollationKey(o2.toString());
            return k1.compareTo(k2);
        }
    }
}

