/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.DefaultErrorHandler;
import io.sf.carte.echosvg.svggen.DefaultExtensionHandler;
import io.sf.carte.echosvg.svggen.DefaultStyleHandler;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.ErrorHandler;
import io.sf.carte.echosvg.svggen.ExtensionHandler;
import io.sf.carte.echosvg.svggen.GenericImageHandler;
import io.sf.carte.echosvg.svggen.ImageHandler;
import io.sf.carte.echosvg.svggen.ImageHandlerBase64Encoder;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGIDGenerator;
import io.sf.carte.echosvg.svggen.SimpleImageHandler;
import io.sf.carte.echosvg.svggen.StyleHandler;
import io.sf.carte.echosvg.svggen.XmlSerializer;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.w3c.dom.Document;

public class SVGGeneratorContext
implements ErrorConstants {
    private Document domFactory;
    private ImageHandler imageHandler;
    private GenericImageHandler genericImageHandler;
    private ExtensionHandler extensionHandler;
    private SVGIDGenerator idGenerator;
    private StyleHandler styleHandler;
    private String generatorComment;
    private ErrorHandler errorHandler;
    private boolean svgFont = false;
    private GraphicContextDefaults gcDefaults;
    private int precision = 4;
    private DecimalFormat decimalFormat = decimalFormats[this.precision];
    private Integer compressionLevel = null;
    private XmlSerializer xmlSerializer = null;
    protected static DecimalFormatSymbols dsf = new DecimalFormatSymbols(Locale.US);
    protected static DecimalFormat[] decimalFormats = new DecimalFormat[13];

    protected SVGGeneratorContext(Document domFactory) {
        this.setDOMFactory(domFactory);
    }

    public static SVGGeneratorContext createDefault(Document domFactory) {
        SVGGeneratorContext ctx = new SVGGeneratorContext(domFactory);
        ctx.setIDGenerator(new SVGIDGenerator());
        ctx.setExtensionHandler(new DefaultExtensionHandler());
        ctx.setImageHandler(new ImageHandlerBase64Encoder());
        ctx.setStyleHandler(new DefaultStyleHandler());
        ctx.setComment("Generated by the EchoSVG Graphics2D SVG Generator");
        ctx.setErrorHandler(new DefaultErrorHandler());
        return ctx;
    }

    public final GraphicContextDefaults getGraphicContextDefaults() {
        return this.gcDefaults;
    }

    public final void setGraphicContextDefaults(GraphicContextDefaults gcDefaults) {
        this.gcDefaults = gcDefaults;
    }

    public final SVGIDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    public final void setIDGenerator(SVGIDGenerator idGenerator) {
        if (idGenerator == null) {
            throw new SVGGraphics2DRuntimeException("idGenerator should not be null");
        }
        this.idGenerator = idGenerator;
    }

    public final Document getDOMFactory() {
        return this.domFactory;
    }

    public final void setDOMFactory(Document domFactory) {
        if (domFactory == null) {
            throw new SVGGraphics2DRuntimeException("domFactory should not be null");
        }
        this.domFactory = domFactory;
    }

    public final ExtensionHandler getExtensionHandler() {
        return this.extensionHandler;
    }

    public final void setExtensionHandler(ExtensionHandler extensionHandler) {
        if (extensionHandler == null) {
            throw new SVGGraphics2DRuntimeException("extensionHandler should not be null");
        }
        this.extensionHandler = extensionHandler;
    }

    public final ImageHandler getImageHandler() {
        return this.imageHandler;
    }

    public final void setImageHandler(ImageHandler imageHandler) {
        if (imageHandler == null) {
            throw new SVGGraphics2DRuntimeException("imageHandler should not be null");
        }
        this.imageHandler = imageHandler;
        this.genericImageHandler = new SimpleImageHandler(imageHandler);
    }

    public final void setGenericImageHandler(GenericImageHandler genericImageHandler) {
        if (genericImageHandler == null) {
            throw new SVGGraphics2DRuntimeException("imageHandler should not be null");
        }
        this.imageHandler = null;
        this.genericImageHandler = genericImageHandler;
    }

    GenericImageHandler getGenericImageHandler() {
        return this.genericImageHandler;
    }

    public final StyleHandler getStyleHandler() {
        return this.styleHandler;
    }

    public final void setStyleHandler(StyleHandler styleHandler) {
        if (styleHandler == null) {
            throw new SVGGraphics2DRuntimeException("styleHandler should not be null");
        }
        this.styleHandler = styleHandler;
    }

    public final String getComment() {
        return this.generatorComment;
    }

    public final void setComment(String generatorComment) {
        this.generatorComment = generatorComment;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new SVGGraphics2DRuntimeException("errorHandler should not be null");
        }
        this.errorHandler = errorHandler;
    }

    public final boolean isEmbeddedFontsOn() {
        return this.svgFont;
    }

    public final void setEmbeddedFontsOn(boolean svgFont) {
        this.svgFont = svgFont;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int precision) {
        this.precision = precision < 0 ? 0 : (precision > 12 ? 12 : precision);
        this.decimalFormat = decimalFormats[this.precision];
    }

    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public final String doubleString(double value) {
        double absvalue = Math.abs(value);
        if (absvalue >= 1.0E8 || (double)((int)value) == value) {
            return Integer.toString((int)value);
        }
        return this.decimalFormat.format(value);
    }

    public XmlSerializer getXmlSerializer() {
        return this.xmlSerializer;
    }

    public void setXmlSerializer(XmlSerializer xmlSerializer) {
        this.xmlSerializer = xmlSerializer;
    }

    static {
        SVGGeneratorContext.decimalFormats[0] = new DecimalFormat("#", dsf);
        String format = "#.";
        for (int i = 1; i < decimalFormats.length; ++i) {
            format = format + "#";
            SVGGeneratorContext.decimalFormats[i] = new DecimalFormat(format, dsf);
        }
    }

    public static class GraphicContextDefaults {
        private Paint paint;
        private Stroke stroke;
        private Composite composite;
        private Shape clip;
        private RenderingHints hints;
        private Font font;
        private Color background;

        public void setStroke(Stroke stroke) {
            this.stroke = stroke;
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        public void setComposite(Composite composite) {
            this.composite = composite;
        }

        public Composite getComposite() {
            return this.composite;
        }

        public void setClip(Shape clip) {
            this.clip = clip;
        }

        public Shape getClip() {
            return this.clip;
        }

        public void setRenderingHints(RenderingHints hints) {
            this.hints = hints;
        }

        public RenderingHints getRenderingHints() {
            return this.hints;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setBackground(Color background) {
            this.background = background;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public Paint getPaint() {
            return this.paint;
        }
    }
}

