/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.DexBuffer;
import com.android.dx.io.EncodedValue;
import com.android.dx.util.Unsigned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Annotation
implements Comparable<Annotation> {
    private final DexBuffer buffer;
    private final byte visibility;
    private final int typeIndex;
    private final int[] names;
    private final EncodedValue[] values;

    public Annotation(DexBuffer buffer, byte visibility, int typeIndex, int[] names, EncodedValue[] values) {
        this.buffer = buffer;
        this.visibility = visibility;
        this.typeIndex = typeIndex;
        this.names = names;
        this.values = values;
    }

    public byte getVisibility() {
        return this.visibility;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int[] getNames() {
        return this.names;
    }

    public EncodedValue[] getValues() {
        return this.values;
    }

    public void writeTo(DexBuffer.Section out) {
        out.writeByte(this.visibility);
        out.writeUleb128(this.typeIndex);
        out.writeUleb128(this.names.length);
        for (int i = 0; i < this.names.length; ++i) {
            out.writeUleb128(this.names[i]);
            this.values[i].writeTo(out);
        }
    }

    @Override
    public int compareTo(Annotation other) {
        if (this.typeIndex != other.typeIndex) {
            return Unsigned.compare(this.typeIndex, other.typeIndex);
        }
        int size = Math.min(this.names.length, other.names.length);
        for (int i = 0; i < size; ++i) {
            if (this.names[i] != other.names[i]) {
                return Unsigned.compare(this.names[i], other.names[i]);
            }
            int compare = this.values[i].compareTo(other.values[i]);
            if (compare == 0) continue;
            return compare;
        }
        return this.names.length - other.names.length;
    }

    public String toString() {
        if (this.buffer == null) {
            return this.visibility + " " + this.typeIndex;
        }
        StringBuilder result = new StringBuilder();
        result.append(this.visibility);
        result.append(" ");
        result.append(this.buffer.typeNames().get(this.typeIndex));
        result.append("[");
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.buffer.strings().get(this.names[i]));
            result.append("=");
            result.append(this.values[i]);
        }
        result.append("]");
        return result.toString();
    }
}

