/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;

public final class MimeMessageUtils {
    public static MimeMessage createMimeMessage(Session session, byte[] source) throws MessagingException, IOException {
        try (SharedByteArrayInputStream inputStream = new SharedByteArrayInputStream(source);){
            MimeMessage mimeMessage = new MimeMessage(session, (InputStream)inputStream);
            return mimeMessage;
        }
    }

    public static MimeMessage createMimeMessage(Session session, File source) throws MessagingException, IOException {
        try (FileInputStream inputStream = new FileInputStream(source);){
            MimeMessage mimeMessage = MimeMessageUtils.createMimeMessage(session, inputStream);
            return mimeMessage;
        }
    }

    public static MimeMessage createMimeMessage(Session session, InputStream source) throws MessagingException {
        return new MimeMessage(session, source);
    }

    public static MimeMessage createMimeMessage(Session session, Path source, OpenOption ... options) throws MessagingException, IOException {
        try (InputStream inputStream = Files.newInputStream(source, options);){
            MimeMessage mimeMessage = MimeMessageUtils.createMimeMessage(session, inputStream);
            return mimeMessage;
        }
    }

    public static MimeMessage createMimeMessage(Session session, String source) throws MessagingException, IOException {
        return MimeMessageUtils.createMimeMessage(session, source.getBytes(StandardCharsets.US_ASCII));
    }

    public static void writeMimeMessage(MimeMessage mimeMessage, File resultFile) throws MessagingException, IOException {
        if (!resultFile.getParentFile().exists() && !resultFile.getParentFile().mkdirs()) {
            throw new IOException("Failed to create the following parent directories: " + resultFile.getParentFile());
        }
        try (FileOutputStream outputStream = new FileOutputStream(resultFile);){
            mimeMessage.writeTo((OutputStream)outputStream);
            outputStream.flush();
        }
    }

    private MimeMessageUtils() {
    }
}

