/*
 * Decompiled with CFR 0.152.
 */
package com.cdnbye.core.nat;

import com.cdnbye.core.nat.ByteArrayWrapper;
import com.cdnbye.core.nat.StunMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunClientHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StunClientHandler.class);
    private static final int UDP_SEND_COUNT = 3;
    private final Map<ByteArrayWrapper, PendingTransaction> pendingTransactions = new ConcurrentHashMap<ByteArrayWrapper, PendingTransaction>();
    private final int transactionTimeoutMs;

    public StunClientHandler(int transactionTimeoutMs) {
        this.transactionTimeoutMs = transactionTimeoutMs;
    }

    public CompletableFuture<StunMessage> doTransaction(StunMessage request, InetSocketAddress remoteAddress, Channel channel) {
        CompletableFuture<StunMessage> future = new CompletableFuture<StunMessage>();
        ByteArrayWrapper transactionId = new ByteArrayWrapper(request.getTransactionId());
        PendingTransaction pending = new PendingTransaction(request, remoteAddress, future, channel);
        this.pendingTransactions.put(transactionId, pending);
        this.sendAndScheduleTimeout(pending, 0);
        return future;
    }

    private void sendAndScheduleTimeout(PendingTransaction transaction, int attempt) {
        if (attempt >= 3) {
            ByteArrayWrapper transactionId = new ByteArrayWrapper(transaction.request.getTransactionId());
            this.pendingTransactions.remove(transactionId);
            transaction.future.completeExceptionally(new SocketTimeoutException("STUN transaction timed out after 3 attempts."));
            return;
        }
        log.debug("Sending STUN request (attempt {}/{}) to {}", new Object[]{attempt + 1, 3, transaction.remoteAddress});
        byte[] requestBytes = transaction.request.toByteData();
        DatagramPacket packet = new DatagramPacket(Unpooled.copiedBuffer((byte[])requestBytes), transaction.remoteAddress);
        transaction.channel.writeAndFlush((Object)packet);
        io.netty.util.concurrent.ScheduledFuture timeoutFuture = transaction.channel.eventLoop().schedule(() -> this.sendAndScheduleTimeout(transaction, attempt + 1), (long)this.transactionTimeoutMs, TimeUnit.MILLISECONDS);
        transaction.setTimeoutFuture((ScheduledFuture<?>)timeoutFuture);
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) {
        byte[] bytes = new byte[((ByteBuf)packet.content()).readableBytes()];
        ((ByteBuf)packet.content()).readBytes(bytes);
        StunMessage response = new StunMessage();
        response.parse(bytes);
        ByteArrayWrapper transactionId = new ByteArrayWrapper(response.getTransactionId());
        PendingTransaction pending = this.pendingTransactions.remove(transactionId);
        if (pending != null) {
            log.debug("Received STUN response for transaction ID: {}", (Object)transactionId);
            if (pending.timeoutFuture != null) {
                pending.timeoutFuture.cancel(false);
            }
            pending.future.complete(response);
        } else {
            log.warn("Received STUN response with unknown transaction ID: {}", (Object)transactionId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("Exception in StunClientHandler", cause);
        ctx.close();
    }

    private static class PendingTransaction {
        final StunMessage request;
        final InetSocketAddress remoteAddress;
        final CompletableFuture<StunMessage> future;
        final Channel channel;
        ScheduledFuture<?> timeoutFuture;

        PendingTransaction(StunMessage request, InetSocketAddress remoteAddress, CompletableFuture<StunMessage> future, Channel channel) {
            this.request = request;
            this.remoteAddress = remoteAddress;
            this.future = future;
            this.channel = channel;
        }

        void setTimeoutFuture(ScheduledFuture<?> timeoutFuture) {
            this.timeoutFuture = timeoutFuture;
        }
    }
}

