/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ping;

import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.InfoHashUtil;
import com.google.gson.annotations.SerializedName;
import java.sql.Timestamp;
import lombok.Generated;

public final class BtnBan {
    @SerializedName(value="module")
    private String module;
    @SerializedName(value="rule")
    private String rule;
    @SerializedName(value="ip_address")
    private String ipAddress;
    @SerializedName(value="port")
    private int peerPort;
    @SerializedName(value="peer_id")
    private String peerId;
    @SerializedName(value="client_name")
    private String clientName;
    @SerializedName(value="torrent_identifier")
    private String torrentIdentifier;
    @SerializedName(value="torrent_is_private")
    private boolean torrentIsPrivate;
    @SerializedName(value="torrent_size")
    private long torrentSize;
    @SerializedName(value="downloaded")
    private long downloaded;
    @SerializedName(value="uploaded")
    private long uploaded;
    @SerializedName(value="progress")
    private double peerProgress;
    @SerializedName(value="downloader_progress")
    private double downloaderProgress;
    @SerializedName(value="peer_flag")
    private String peerFlag;
    @SerializedName(value="ban_at")
    private Timestamp banAt;
    @SerializedName(value="structured_data")
    private String structuredData;

    public static BtnBan from(HistoryEntity historyEntity) {
        BtnBan btnBan = new BtnBan();
        btnBan.setModule(historyEntity.getRule().getModule().getName());
        btnBan.setRule(TextManager.tlUI(historyEntity.getRule().getRule()));
        btnBan.setIpAddress(historyEntity.getIp());
        btnBan.setPeerPort(historyEntity.getPort());
        btnBan.setPeerId(historyEntity.getPeerId());
        btnBan.setClientName(historyEntity.getPeerClientName());
        btnBan.setTorrentIdentifier(InfoHashUtil.getHashedIdentifier(historyEntity.getTorrent().getInfoHash()));
        btnBan.setTorrentIsPrivate(Boolean.TRUE.equals(historyEntity.getTorrent().getPrivateTorrent()));
        btnBan.setTorrentSize(historyEntity.getTorrent().getSize());
        btnBan.setDownloaded(historyEntity.getPeerDownloaded());
        btnBan.setUploaded(historyEntity.getPeerUploaded());
        btnBan.setPeerProgress(historyEntity.getPeerProgress());
        btnBan.setDownloaderProgress(historyEntity.getDownloaderProgress());
        btnBan.setPeerFlag(historyEntity.getFlags() == null ? null : historyEntity.getFlags());
        btnBan.setBanAt(historyEntity.getBanAt());
        btnBan.setStructuredData(historyEntity.getStructuredData());
        return btnBan;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public String getRule() {
        return this.rule;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public int getPeerPort() {
        return this.peerPort;
    }

    @Generated
    public String getPeerId() {
        return this.peerId;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getTorrentIdentifier() {
        return this.torrentIdentifier;
    }

    @Generated
    public boolean isTorrentIsPrivate() {
        return this.torrentIsPrivate;
    }

    @Generated
    public long getTorrentSize() {
        return this.torrentSize;
    }

    @Generated
    public long getDownloaded() {
        return this.downloaded;
    }

    @Generated
    public long getUploaded() {
        return this.uploaded;
    }

    @Generated
    public double getPeerProgress() {
        return this.peerProgress;
    }

    @Generated
    public double getDownloaderProgress() {
        return this.downloaderProgress;
    }

    @Generated
    public String getPeerFlag() {
        return this.peerFlag;
    }

    @Generated
    public Timestamp getBanAt() {
        return this.banAt;
    }

    @Generated
    public String getStructuredData() {
        return this.structuredData;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public void setRule(String rule) {
        this.rule = rule;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    @Generated
    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setTorrentIdentifier(String torrentIdentifier) {
        this.torrentIdentifier = torrentIdentifier;
    }

    @Generated
    public void setTorrentIsPrivate(boolean torrentIsPrivate) {
        this.torrentIsPrivate = torrentIsPrivate;
    }

    @Generated
    public void setTorrentSize(long torrentSize) {
        this.torrentSize = torrentSize;
    }

    @Generated
    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    @Generated
    public void setUploaded(long uploaded) {
        this.uploaded = uploaded;
    }

    @Generated
    public void setPeerProgress(double peerProgress) {
        this.peerProgress = peerProgress;
    }

    @Generated
    public void setDownloaderProgress(double downloaderProgress) {
        this.downloaderProgress = downloaderProgress;
    }

    @Generated
    public void setPeerFlag(String peerFlag) {
        this.peerFlag = peerFlag;
    }

    @Generated
    public void setBanAt(Timestamp banAt) {
        this.banAt = banAt;
    }

    @Generated
    public void setStructuredData(String structuredData) {
        this.structuredData = structuredData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BtnBan)) {
            return false;
        }
        BtnBan other = (BtnBan)o;
        if (this.getPeerPort() != other.getPeerPort()) {
            return false;
        }
        if (this.isTorrentIsPrivate() != other.isTorrentIsPrivate()) {
            return false;
        }
        if (this.getTorrentSize() != other.getTorrentSize()) {
            return false;
        }
        if (this.getDownloaded() != other.getDownloaded()) {
            return false;
        }
        if (this.getUploaded() != other.getUploaded()) {
            return false;
        }
        if (Double.compare(this.getPeerProgress(), other.getPeerProgress()) != 0) {
            return false;
        }
        if (Double.compare(this.getDownloaderProgress(), other.getDownloaderProgress()) != 0) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$peerId = this.getPeerId();
        String other$peerId = other.getPeerId();
        if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$torrentIdentifier = this.getTorrentIdentifier();
        String other$torrentIdentifier = other.getTorrentIdentifier();
        if (this$torrentIdentifier == null ? other$torrentIdentifier != null : !this$torrentIdentifier.equals(other$torrentIdentifier)) {
            return false;
        }
        String this$peerFlag = this.getPeerFlag();
        String other$peerFlag = other.getPeerFlag();
        if (this$peerFlag == null ? other$peerFlag != null : !this$peerFlag.equals(other$peerFlag)) {
            return false;
        }
        Timestamp this$banAt = this.getBanAt();
        Timestamp other$banAt = other.getBanAt();
        if (this$banAt == null ? other$banAt != null : !((Object)this$banAt).equals(other$banAt)) {
            return false;
        }
        String this$structuredData = this.getStructuredData();
        String other$structuredData = other.getStructuredData();
        return !(this$structuredData == null ? other$structuredData != null : !this$structuredData.equals(other$structuredData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeerPort();
        result = result * 59 + (this.isTorrentIsPrivate() ? 79 : 97);
        long $torrentSize = this.getTorrentSize();
        result = result * 59 + (int)($torrentSize >>> 32 ^ $torrentSize);
        long $downloaded = this.getDownloaded();
        result = result * 59 + (int)($downloaded >>> 32 ^ $downloaded);
        long $uploaded = this.getUploaded();
        result = result * 59 + (int)($uploaded >>> 32 ^ $uploaded);
        long $peerProgress = Double.doubleToLongBits(this.getPeerProgress());
        result = result * 59 + (int)($peerProgress >>> 32 ^ $peerProgress);
        long $downloaderProgress = Double.doubleToLongBits(this.getDownloaderProgress());
        result = result * 59 + (int)($downloaderProgress >>> 32 ^ $downloaderProgress);
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $peerId = this.getPeerId();
        result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $torrentIdentifier = this.getTorrentIdentifier();
        result = result * 59 + ($torrentIdentifier == null ? 43 : $torrentIdentifier.hashCode());
        String $peerFlag = this.getPeerFlag();
        result = result * 59 + ($peerFlag == null ? 43 : $peerFlag.hashCode());
        Timestamp $banAt = this.getBanAt();
        result = result * 59 + ($banAt == null ? 43 : ((Object)$banAt).hashCode());
        String $structuredData = this.getStructuredData();
        result = result * 59 + ($structuredData == null ? 43 : $structuredData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BtnBan(module=" + this.getModule() + ", rule=" + this.getRule() + ", ipAddress=" + this.getIpAddress() + ", peerPort=" + this.getPeerPort() + ", peerId=" + this.getPeerId() + ", clientName=" + this.getClientName() + ", torrentIdentifier=" + this.getTorrentIdentifier() + ", torrentIsPrivate=" + this.isTorrentIsPrivate() + ", torrentSize=" + this.getTorrentSize() + ", downloaded=" + this.getDownloaded() + ", uploaded=" + this.getUploaded() + ", peerProgress=" + this.getPeerProgress() + ", downloaderProgress=" + this.getDownloaderProgress() + ", peerFlag=" + this.getPeerFlag() + ", banAt=" + String.valueOf(this.getBanAt()) + ", structuredData=" + this.getStructuredData() + ")";
    }

    @Generated
    public BtnBan(String module, String rule, String ipAddress, int peerPort, String peerId, String clientName, String torrentIdentifier, boolean torrentIsPrivate, long torrentSize, long downloaded, long uploaded, double peerProgress, double downloaderProgress, String peerFlag, Timestamp banAt, String structuredData) {
        this.module = module;
        this.rule = rule;
        this.ipAddress = ipAddress;
        this.peerPort = peerPort;
        this.peerId = peerId;
        this.clientName = clientName;
        this.torrentIdentifier = torrentIdentifier;
        this.torrentIsPrivate = torrentIsPrivate;
        this.torrentSize = torrentSize;
        this.downloaded = downloaded;
        this.uploaded = uploaded;
        this.peerProgress = peerProgress;
        this.downloaderProgress = downloaderProgress;
        this.peerFlag = peerFlag;
        this.banAt = banAt;
        this.structuredData = structuredData;
    }

    @Generated
    public BtnBan() {
    }
}

