/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.PeerConnectionMetricsTrackEntity;
import com.ghostchu.peerbanhelper.database.table.TorrentEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PeerConnectionMetricsTrackDao
extends AbstractPBHDao<PeerConnectionMetricsTrackEntity, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerConnectionMetricsTrackDao.class);

    public PeerConnectionMetricsTrackDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, PeerConnectionMetricsTrackEntity.class);
    }

    public void upsertPeerSession(@NotNull Downloader downloader, @NotNull TorrentEntity torrent, @NotNull Collection<Peer> peers) {
        long startOfDay = MiscUtil.getStartOfToday(System.currentTimeMillis());
        Timestamp startOfDayTs = new Timestamp(startOfDay);
        try {
            ArrayList<PeerConnectionMetricsTrackEntity> entities = new ArrayList<PeerConnectionMetricsTrackEntity>();
            for (Peer peer : peers) {
                PeerConnectionMetricsTrackEntity entity = (PeerConnectionMetricsTrackEntity)this.queryBuilder().where().eq("timeframeAt", (Object)startOfDay).and().eq("downloader", (Object)downloader.getId()).and().eq("torrent_id", (Object)torrent).and().eq("address", (Object)peer.getPeerAddress().getAddress().toNormalizedString()).and().eq("port", (Object)peer.getPeerAddress().getPort()).queryForFirst();
                if (entity == null) {
                    entity = new PeerConnectionMetricsTrackEntity();
                    entity.setTimeframeAt(startOfDayTs);
                    entity.setDownloader(downloader.getId());
                    entity.setTorrent(torrent);
                    entity.setAddress(peer.getPeerAddress().getAddress().toNormalizedString());
                    entity.setPort(peer.getPeerAddress().getPort());
                }
                entity.setPeerId(peer.getPeerId());
                entity.setClientName(peer.getClientName());
                entity.setLastFlags(peer.getFlags() == null ? null : peer.getFlags().getLtStdString());
                entities.add(entity);
            }
            this.callBatchTasks(() -> {
                for (PeerConnectionMetricsTrackEntity entity : entities) {
                    try {
                        this.createOrUpdate(entity);
                    }
                    catch (SQLException sqle) {
                        log.warn("Failed to update or create peer session entity {}", (Object)entity, (Object)sqle);
                    }
                }
                return null;
            });
        }
        catch (SQLException e) {
            log.error("Failed to upsert peer sessions", (Throwable)e);
        }
    }
}

