/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl.tmp;

import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.tmp.TrackedSwarmEntity;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TrackedSwarmDao
extends AbstractPBHDao<TrackedSwarmEntity, Long> {
    public TrackedSwarmDao(@Autowired ConnectionSource source) throws SQLException {
        super(source, TrackedSwarmEntity.class);
    }

    public Page<TrackedSwarmEntity> getPendingSubmitTrackedPeers(Pageable pageable, long idAfterThan) throws SQLException {
        QueryBuilder queryBuilder = this.queryBuilder().where().gt("id", (Object)idAfterThan).queryBuilder().orderBy("id", true);
        return this.queryByPaging(queryBuilder, pageable);
    }

    public int upsert(TrackedSwarmEntity newData) throws SQLException {
        TrackedSwarmEntity lastData = (TrackedSwarmEntity)this.queryBuilder().where().eq("ip", (Object)newData.getIp()).and().eq("port", (Object)newData.getPort()).and().eq("infoHash", (Object)newData.getInfoHash()).and().eq("downloader", (Object)newData.getDownloader()).queryForFirst();
        if (lastData != null) {
            long newUploaded;
            long newDownloaded;
            if (newData.getDownloadedOffset() < lastData.getDownloadedOffset() || newData.getUploadedOffset() < lastData.getUploadedOffset()) {
                newDownloaded = newData.getDownloadedOffset() - lastData.getDownloadedOffset();
                newUploaded = newData.getUploadedOffset() - lastData.getUploadedOffset();
            } else {
                newDownloaded = newData.getDownloadedOffset();
                newUploaded = newData.getUploadedOffset();
            }
            lastData.setDownloaded(lastData.getDownloaded() + newDownloaded);
            lastData.setUploaded(lastData.getUploaded() + newUploaded);
            lastData.setDownloadedOffset(newData.getDownloadedOffset());
            lastData.setUploadedOffset(newData.getUploadedOffset());
            lastData.setClientName(newData.getClientName());
            lastData.setPeerId(newData.getPeerId());
            lastData.setLastFlags(newData.getLastFlags());
            lastData.setLastTimeSeen(newData.getLastTimeSeen());
            return this.update(lastData);
        }
        return this.create(newData);
    }
}

