/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.PeerBanHelper;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import inet.ipaddr.IPAddress;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class AutoRangeBan
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoRangeBan.class);
    @Autowired
    private PeerBanHelper peerBanHelper;
    private int ipv4Prefix;
    private int ipv6Prefix;
    @Autowired
    private JavalinWebContainer webContainer;
    private long banDuration;
    @Autowired
    private DownloaderServer downloaderServer;
    @Autowired
    private BanList banList;

    @Override
    @NotNull
    public String getName() {
        return "Auto Range Ban";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "auto-range-ban";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        this.webContainer.javalin().get("/api/modules/" + this.getConfigName(), this::handleWebAPI, new RouteRole[]{Role.USER_READ});
        Main.getReloadManager().register((Reloadable)this);
    }

    @Override
    public boolean isThreadSafe() {
        return super.isThreadSafe();
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void handleWebAPI(Context ctx) {
        ctx.json((Object)new StdResp(true, null, Map.of("ipv4-prefix", this.ipv4Prefix, "ipv6-prefix", this.ipv6Prefix)));
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    private void reloadConfig() {
        this.ipv4Prefix = this.getConfig().getInt("ipv4");
        this.ipv6Prefix = this.getConfig().getInt("ipv6");
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.getCache().invalidateAll();
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        if (this.isHandShaking(peer)) {
            return this.pass();
        }
        if (this.banList.contains(peer.getPeerAddress())) {
            return this.pass();
        }
        IPAddress peerAddress = peer.getPeerAddress().getAddress().withoutPrefixLength();
        if (peerAddress.isIPv4Convertible()) {
            peerAddress = peerAddress.toIPv4();
        }
        AtomicReference<Object> reference = new AtomicReference<Object>(null);
        IPAddress finalPeerAddress = peerAddress;
        this.banList.forEach((bannedAddr, bannedMeta) -> {
            if (reference.get() != null) {
                return;
            }
            if (bannedMeta.isBanForDisconnect()) {
                return;
            }
            if (finalPeerAddress.isIPv4() != bannedAddr.isIPv4()) {
                return;
            }
            Object addressType = "UNKNOWN";
            if (bannedAddr.isIPv4()) {
                addressType = "IPv4/" + this.ipv4Prefix;
                bannedAddr = IPAddressUtil.toPrefixBlockAndZeroHost(bannedAddr, this.ipv4Prefix);
            }
            if (bannedAddr.isIPv6()) {
                addressType = "IPv6/" + this.ipv6Prefix;
                bannedAddr = IPAddressUtil.toPrefixBlockAndZeroHost(bannedAddr, this.ipv6Prefix);
            }
            if (bannedAddr.contains(finalPeerAddress)) {
                reference.set(new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent((String)addressType), new TranslationComponent(Lang.ARB_BANNED, finalPeerAddress.toString(), finalPeerAddress.toString(), bannedAddr.toString(), addressType), StructuredData.create().add("relatedBannedAddress", bannedAddr.toNormalizedString())));
            }
        });
        CheckResult result = reference.get();
        return Objects.requireNonNullElseGet(result, this::pass);
    }
}

