/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.impl.RuleSubLogsDao;
import com.ghostchu.peerbanhelper.database.table.RuleSubInfoEntity;
import com.ghostchu.peerbanhelper.database.table.RuleSubLogEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.IPBanRuleUpdateType;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.module.impl.rule.dto.DataUpdateResultDTO;
import com.ghostchu.peerbanhelper.module.impl.rule.dto.IPBanResultDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.ghostchu.peerbanhelper.util.rule.ModuleMatchCache;
import com.ghostchu.peerbanhelper.util.rule.matcher.IPMatcher;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.DualIPv4v6AssociativeTries;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class IPBlackRuleList
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IPBlackRuleList.class);
    private final RuleSubLogsDao ruleSubLogsDao;
    private final ModuleMatchCache moduleMatchCache;
    private List<IPMatcher> ipBanMatchers;
    private long checkInterval = 86400000L;
    private long banDuration;
    @Autowired
    private HTTPUtil httpUtil;
    private boolean preloadBanList;

    public IPBlackRuleList(RuleSubLogsDao ruleSubLogsDao, ModuleMatchCache moduleMatchCache) {
        this.ruleSubLogsDao = ruleSubLogsDao;
        this.moduleMatchCache = moduleMatchCache;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "IP Blacklist Rule List";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "ip-address-blocker-rules";
    }

    @Override
    public void onEnable() {
        ConfigurationSection config = this.getConfig();
        this.checkInterval = config.getLong("check-interval", this.checkInterval);
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::reloadConfig, 0L, this.checkInterval, TimeUnit.MILLISECONDS);
        Main.getReloadManager().register((Reloadable)this);
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        if (this.isHandShaking(peer)) {
            return this.handshaking();
        }
        String ip = peer.getPeerAddress().getIp();
        ArrayList results = new ArrayList();
        this.ipBanMatchers.forEach(rule -> results.add(new IPBanResultDTO(rule.getRuleName(), rule.match(ip))));
        for (IPBanResultDTO ipBanResultDTO : results) {
            try {
                if (ipBanResultDTO == null) {
                    return this.pass();
                }
                boolean match = ipBanResultDTO.matchResult().result() == MatchResultEnum.TRUE;
                if (!match) continue;
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(ipBanResultDTO.ruleName()), new TranslationComponent(Lang.MODULE_IBL_MATCH_IP_RULE, ipBanResultDTO.ruleName(), ip, Optional.ofNullable(ipBanResultDTO.matchResult().comment()).orElse(new TranslationComponent(Lang.MODULE_IBL_COMMENT_UNKNOWN))), StructuredData.create().add("ruleName", ipBanResultDTO.ruleName()));
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.IP_BAN_RULE_MATCH_ERROR, new Object[0]), (Throwable)e);
                return this.pass();
            }
        }
        return this.pass();
    }

    private void reloadConfig() {
        this.getCache().invalidateAll();
        try {
            this.banDuration = this.getConfig().getLong("ban-duration", 0L);
            this.preloadBanList = this.getConfig().getBoolean("preload-banlist", false);
            if (null == this.ipBanMatchers) {
                this.ipBanMatchers = new ArrayList<IPMatcher>();
            }
            ConfigurationSection config = this.getConfig();
            this.checkInterval = config.getLong("check-interval", this.checkInterval);
            ConfigurationSection rules = this.getRuleSubsConfig();
            if (null != rules) {
                for (String ruleId : rules.getKeys(false)) {
                    ConfigurationSection rule = rules.getConfigurationSection(ruleId);
                    assert (rule != null);
                    try {
                        this.updateRule(Main.DEF_LOCALE, rule, IPBanRuleUpdateType.AUTO);
                        log.info(TextManager.tlUI(Lang.IP_BAN_RULE_UPDATE_FINISH, new Object[0]));
                    }
                    catch (Exception e) {
                        log.warn(TextManager.tlUI(Lang.IP_BAN_RULE_UPDATE_FAILED, rule.getString("name")), (Throwable)e);
                    }
                }
            }
            this.getCache().invalidateAll();
        }
        catch (Throwable throwable) {
            log.error("Unable to complete scheduled tasks", throwable);
        }
    }

    public StdResp updateRule(String locale, @NotNull ConfigurationSection rule, IPBanRuleUpdateType updateType) {
        AtomicReference<StdResp> result = new AtomicReference<StdResp>();
        String ruleId = rule.getName();
        String name = rule.getString("name", ruleId);
        if (name.contains(".")) {
            throw new IllegalArgumentException("Illegal character (.) in name: " + name);
        }
        if (!rule.getBoolean("enabled", false)) {
            this.ipBanMatchers.removeIf(ele -> ele.getRuleId().equals(ruleId));
            return new StdResp(false, TextManager.tl(locale, Lang.IP_BAN_RULE_DISABLED, ruleId), null);
        }
        String url = rule.getString("url");
        if (null != url) {
            String ruleFileName = ruleId + ".txt";
            File dir = new File(Main.getDataDirectory(), "/sub");
            dir.mkdirs();
            File ruleFile = new File(dir, ruleFileName);
            DualIPv4v6AssociativeTries ipAddresses = new DualIPv4v6AssociativeTries();
            ((CompletableFuture)this.getResource(url).whenComplete((dataUpdateResultDTO, throwable) -> {
                if (throwable != null) {
                    if (ruleFile.exists()) {
                        if (this.ipBanMatchers.stream().noneMatch(ele -> ele.getRuleId().equals(ruleId))) {
                            try {
                                this.fileToIPList(ruleFile, (DualIPv4v6AssociativeTries<String>)ipAddresses);
                                this.ipBanMatchers.add(new IPMatcher(ruleId, name, List.of(ipAddresses)));
                                log.warn(TextManager.tlUI(Lang.IP_BAN_RULE_USE_CACHE, name));
                                result.set(new StdResp(false, TextManager.tl(locale, Lang.IP_BAN_RULE_USE_CACHE, name), null));
                            }
                            catch (IOException ex) {
                                log.error(TextManager.tlUI(Lang.IP_BAN_RULE_LOAD_FAILED, name), (Throwable)ex);
                                result.set(new StdResp(false, TextManager.tl(locale, Lang.IP_BAN_RULE_LOAD_FAILED, name), null));
                            }
                        } else {
                            result.set(new StdResp(false, TextManager.tl(locale, Lang.IP_BAN_RULE_UPDATE_FAILED, name), null));
                        }
                    } else {
                        result.set(new StdResp(false, TextManager.tl(locale, Lang.IP_BAN_RULE_LOAD_FAILED, name), null));
                    }
                    throw new RuntimeException((Throwable)throwable);
                }
                try {
                    HashCode ruleHash = null;
                    HashCode tempHash = Hashing.sha256().hashBytes(dataUpdateResultDTO.data());
                    if (ruleFile.exists()) {
                        ruleHash = Files.asByteSource((File)ruleFile).hash(Hashing.sha256());
                    }
                    int ent_count = 0;
                    if (!tempHash.equals((Object)ruleHash)) {
                        ent_count = this.stringToIPList(new String(dataUpdateResultDTO.data(), StandardCharsets.UTF_8), (DualIPv4v6AssociativeTries<String>)ipAddresses);
                        Files.write((byte[])dataUpdateResultDTO.data(), (File)ruleFile);
                    } else if (this.ipBanMatchers.stream().noneMatch(ele -> ele.getRuleId().equals(ruleId))) {
                        ent_count = this.stringToIPList(new String(dataUpdateResultDTO.data(), StandardCharsets.UTF_8), (DualIPv4v6AssociativeTries<String>)ipAddresses);
                    } else {
                        log.info(TextManager.tlUI(Lang.IP_BAN_RULE_NO_UPDATE, name));
                        result.set(new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_NO_UPDATE, name), null));
                    }
                    if (ent_count > 0) {
                        this.ipBanMatchers.stream().filter(ele -> ele.getRuleId().equals(ruleId)).findFirst().ifPresentOrElse(ele -> {
                            ele.setData(name, List.of(ipAddresses));
                            this.moduleMatchCache.invalidateAll();
                            log.info(TextManager.tlUI(Lang.IP_BAN_RULE_UPDATE_SUCCESS, name));
                            result.set(new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_UPDATE_SUCCESS, name), null));
                        }, () -> {
                            this.ipBanMatchers.add(new IPMatcher(ruleId, name, List.of(ipAddresses)));
                            log.info(TextManager.tlUI(Lang.IP_BAN_RULE_LOAD_SUCCESS, name));
                            result.set(new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_LOAD_SUCCESS, name), null));
                        });
                        try {
                            this.ruleSubLogsDao.create(new RuleSubLogEntity(null, ruleId, System.currentTimeMillis(), ent_count, updateType));
                            result.set(new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_UPDATED, name), null));
                        }
                        catch (SQLException e) {
                            log.error(TextManager.tlUI(Lang.IP_BAN_RULE_UPDATE_LOG_ERROR, ruleId), (Throwable)e);
                            result.set(new StdResp(false, TextManager.tl(locale, Lang.IP_BAN_RULE_UPDATE_LOG_ERROR, name), null));
                        }
                    } else {
                        result.set(new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_NO_UPDATE, name), null));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.moduleMatchCache.invalidateAll();
                }
            })).join();
        } else {
            result.set(new StdResp(false, TextManager.tl(locale, Lang.IP_BAN_RULE_URL_WRONG, name), null));
        }
        return (StdResp)result.get();
    }

    private CompletableFuture<DataUpdateResultDTO> getResource(String url) {
        return CompletableFuture.supplyAsync(() -> {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (uri.getScheme().startsWith("http")) {
                DataUpdateResultDTO dataUpdateResultDTO;
                block11: {
                    OkHttpClient client = this.httpUtil.newBuilder().build();
                    Request request = new Request.Builder().url(url).get().build();
                    Response response = client.newCall(request).execute();
                    try {
                        dataUpdateResultDTO = new DataUpdateResultDTO(response.code(), null, response.body().bytes());
                        if (response == null) break block11;
                    }
                    catch (Throwable t$) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable x2) {
                                    t$.addSuppressed(x2);
                                }
                            }
                            throw t$;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    response.close();
                }
                return dataUpdateResultDTO;
            }
            throw new IllegalArgumentException("Invalid URL");
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fileToIPList(File ruleFile, DualIPv4v6AssociativeTries<String> ips) throws IOException {
        AtomicInteger count = new AtomicInteger();
        StringJoiner sj = new StringJoiner("\n");
        List lines = Files.readLines((File)ruleFile, (Charset)StandardCharsets.UTF_8);
        for (String ele : lines) {
            if (ele.isBlank()) continue;
            if (ele.startsWith("#")) {
                sj.add(ele.substring(1));
                continue;
            }
            try {
                Map.Entry<IPAddress, String> parsedIp = this.parseRuleLine(ele, sj.toString());
                if (parsedIp == null) continue;
                count.getAndIncrement();
                ips.put(parsedIp.getKey(), (Object)parsedIp.getValue());
            }
            catch (Exception e) {
                log.error("Unable parse rule: {}", (Object)ele, (Object)e);
            }
            finally {
                sj = new StringJoiner("\n");
            }
        }
        return count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stringToIPList(String data, DualIPv4v6AssociativeTries<String> ips) {
        AtomicInteger count = new AtomicInteger();
        StringJoiner sj = new StringJoiner("\n");
        for (String ele : data.split("\n")) {
            if (ele.isBlank()) continue;
            if (ele.startsWith("#")) {
                sj.add(ele.substring(1));
                continue;
            }
            try {
                Map.Entry<IPAddress, String> parsedIp = this.parseRuleLine(ele, sj.toString());
                if (parsedIp == null) continue;
                count.getAndIncrement();
                ips.put(parsedIp.getKey(), (Object)parsedIp.getValue());
            }
            catch (Exception e) {
                log.error("Unable parse rule: {}", (Object)ele, (Object)e);
            }
            finally {
                sj = new StringJoiner("\n");
            }
        }
        return count.get();
    }

    private Map.Entry<IPAddress, @Nullable String> parseRuleLine(String ele, String preReadComment) {
        if (ele.contains(",")) {
            String comment;
            String[] spilted = ele.split(",");
            if (spilted.length < 3) {
                return null;
            }
            IPAddress start = IPAddressUtil.getIPAddress(spilted[0]);
            IPAddress end = IPAddressUtil.getIPAddress(spilted[1]);
            int level = Integer.parseInt(spilted[2]);
            String string = comment = spilted.length > 3 ? spilted[3] : preReadComment;
            if (level >= 128) {
                return null;
            }
            if (start == null || end == null) {
                return null;
            }
            return Map.entry(start.spanWithRange(end).coverWithPrefixBlock(), comment);
        }
        if (ele.contains("#")) {
            String ip = ele.substring(0, ele.indexOf("#"));
            String comment = null;
            if (ele.contains("#")) {
                comment = ele.substring(ele.indexOf("#") + 1);
            }
            return Map.entry(IPAddressUtil.getIPAddress(ip), Optional.ofNullable(comment).orElse(preReadComment));
        }
        return Map.entry(IPAddressUtil.getIPAddress(ele), preReadComment);
    }

    public ConfigurationSection getRuleSubsConfig() {
        return this.getConfig().getConfigurationSection("rules");
    }

    public RuleSubInfoEntity getRuleSubInfo(String ruleId) throws SQLException {
        ConfigurationSection rules = this.getRuleSubsConfig();
        if (rules == null) {
            return null;
        }
        ConfigurationSection rule = rules.getConfigurationSection(ruleId);
        if (rule == null) {
            return null;
        }
        List result = this.ruleSubLogsDao.queryByPaging(this.ruleSubLogsDao.queryBuilder().orderBy("id", false).where().eq("ruleId", (Object)new SelectArg((Object)ruleId)).queryBuilder(), new Pageable(1L, 1L)).getResults();
        Optional<RuleSubLogEntity> first = result.isEmpty() ? Optional.empty() : Optional.of((RuleSubLogEntity)result.getFirst());
        long lastUpdate = first.map(RuleSubLogEntity::getUpdateTime).orElse(0L);
        int count = first.map(RuleSubLogEntity::getCount).orElse(0);
        return new RuleSubInfoEntity(ruleId, rule.getBoolean("enabled", false), rule.getString("name", ruleId), rule.getString("url"), lastUpdate, count);
    }

    public ConfigurationSection saveRuleSubInfo(@NotNull RuleSubInfoEntity ruleSubInfo) throws IOException {
        ConfigurationSection rules = this.getRuleSubsConfig();
        String ruleId = ruleSubInfo.getRuleId().trim();
        if (ruleId.contains(".")) {
            throw new IllegalArgumentException("Character '.' is not allowed.");
        }
        rules.set(ruleId + ".enabled", (Object)ruleSubInfo.isEnabled());
        rules.set(ruleId + ".name", (Object)ruleSubInfo.getRuleName().trim());
        rules.set(ruleId + ".url", (Object)ruleSubInfo.getSubUrl());
        this.saveConfig();
        return rules.getConfigurationSection(ruleId);
    }

    public void deleteRuleSubInfo(String ruleId) throws IOException {
        ConfigurationSection rules = this.getRuleSubsConfig();
        rules.set(ruleId, null);
        this.saveConfig();
    }

    public Page<RuleSubLogEntity> queryRuleSubLogs(String ruleId, Pageable pageable) throws SQLException {
        QueryBuilder builder = this.ruleSubLogsDao.queryBuilder().orderBy("updateTime", false);
        if (ruleId != null) {
            builder = builder.where().eq("ruleId", (Object)new SelectArg((Object)ruleId)).queryBuilder();
        }
        return this.ruleSubLogsDao.queryByPaging(builder, pageable);
    }

    public long countRuleSubLogs(String ruleId) throws SQLException {
        QueryBuilder builder = this.ruleSubLogsDao.queryBuilder();
        if (ruleId != null) {
            builder = builder.where().eq("ruleId", (Object)new SelectArg((Object)ruleId)).queryBuilder();
        }
        return this.ruleSubLogsDao.countOf(builder.setCountOf(true).prepare());
    }

    public void changeCheckInterval(long checkInterval) throws IOException {
        this.checkInterval = checkInterval;
        this.getConfig().set("check-interval", (Object)checkInterval);
        this.saveConfig();
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::reloadConfig, 0L, checkInterval, TimeUnit.MILLISECONDS);
    }

    private void preloadBanList() {
    }

    @Generated
    public RuleSubLogsDao getRuleSubLogsDao() {
        return this.ruleSubLogsDao;
    }

    @Generated
    public ModuleMatchCache getModuleMatchCache() {
        return this.moduleMatchCache;
    }

    @Generated
    public List<IPMatcher> getIpBanMatchers() {
        return this.ipBanMatchers;
    }

    @Generated
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Generated
    public long getBanDuration() {
        return this.banDuration;
    }

    @Generated
    public HTTPUtil getHttpUtil() {
        return this.httpUtil;
    }

    @Generated
    public boolean isPreloadBanList() {
        return this.preloadBanList;
    }
}

