/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.ModuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerRecordDao;
import com.ghostchu.peerbanhelper.database.dao.impl.RuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.database.table.TorrentEntity;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BanLogDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerRecordEntityDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TorrentEntityDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TorrentInfoDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class PBHTorrentController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHTorrentController.class);
    private final JavalinWebContainer javalinWebContainer;
    private final TorrentDao torrentDao;
    private final PeerRecordDao peerRecordDao;
    private final HistoryDao historyDao;
    private final DownloaderManagerImpl downloaderManager;
    private final RuleDao ruleDao;
    private final ModuleDao moduleDao;

    public PBHTorrentController(JavalinWebContainer javalinWebContainer, TorrentDao torrentDao, PeerRecordDao peerRecordDao, HistoryDao historyDao, DownloaderManagerImpl downloaderManager, RuleDao ruleDao, ModuleDao moduleDao) {
        this.javalinWebContainer = javalinWebContainer;
        this.torrentDao = torrentDao;
        this.historyDao = historyDao;
        this.peerRecordDao = peerRecordDao;
        this.downloaderManager = downloaderManager;
        this.ruleDao = ruleDao;
        this.moduleDao = moduleDao;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "Torrent Controller";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "torrent-controller";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)this.javalinWebContainer.javalin().get("/api/torrent/query", this::handleTorrentQuery, new RouteRole[]{Role.USER_READ})).get("/api/torrent/{infoHash}", this::handleTorrentInfo, new RouteRole[]{Role.USER_READ})).get("/api/torrent/{infoHash}/accessHistory", this::handleConnectHistory, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/torrent/{infoHash}/banHistory", this::handleBanHistory, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS});
    }

    private void handleBanHistory(Context ctx) throws SQLException {
        Optional<TorrentEntity> torrent = this.torrentDao.queryByInfoHash(ctx.pathParam("infoHash"));
        if (torrent.isEmpty()) {
            ctx.status(404);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.TORRENT_NOT_FOUND, new Object[0]), null));
            return;
        }
        Pageable pageable = new Pageable(ctx);
        TorrentEntity t = torrent.get();
        Page page = this.historyDao.queryByPaging(new Orderable(Map.of("banAt", false), ctx).addMapping("torrent.name", "torrentName").addMapping("torrent.infoHash", "torrentInfoHash").addMapping("torrent.size", "torrentSize").addMapping("module.name", "module").addMapping("rule.rule", "rule").addMapping("ip", "peerIp").apply(this.historyDao.queryBuilder().where().eq("torrent_id", (Object)new SelectArg((Object)t)).queryBuilder().join(this.torrentDao.queryBuilder().setAlias("torrent"), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND).join(this.ruleDao.queryBuilder().setAlias("rule").join(this.moduleDao.queryBuilder().setAlias("module"), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND)), pageable);
        List<BanLogDTO> result = page.getResults().stream().map(r -> new BanLogDTO(this.locale(ctx), this.downloaderManager, (HistoryEntity)r)).toList();
        ctx.json((Object)new StdResp(true, null, new Page<BanLogDTO>(pageable, page.getTotal(), result)));
    }

    private void handleTorrentQuery(Context ctx) throws SQLException {
        Pageable pageable = new Pageable(ctx);
        boolean needsCountSort = false;
        String countSortField = null;
        boolean countSortAscending = true;
        for (String orderByParam : ctx.queryParams("orderBy")) {
            String[] parts = orderByParam.split("\\|");
            String field = parts[0];
            if (!"peerBanCount".equals(field) && !"peerAccessCount".equals(field)) continue;
            needsCountSort = true;
            countSortField = field;
            countSortAscending = parts.length < 2 || !parts[1].equalsIgnoreCase("desc") && !parts[1].equalsIgnoreCase("descend");
            break;
        }
        QueryBuilder qb = this.torrentDao.queryBuilder();
        if (ctx.queryParam("keyword") != null) {
            qb.where().like("name", (Object)new SelectArg((Object)("%" + ctx.queryParam("keyword") + "%"))).or().like("infoHash", (Object)new SelectArg((Object)("%" + ctx.queryParam("keyword") + "%")));
        }
        if (needsCountSort) {
            String subQueryTable = "peerBanCount".equals(countSortField) ? "history" : "peer_record";
            String sortDirection = countSortAscending ? "ASC" : "DESC";
            qb.orderByRaw("(SELECT COUNT(*) FROM " + subQueryTable + " WHERE " + subQueryTable + ".torrent_id = torrents.id) " + sortDirection);
        } else {
            new Orderable(Map.of("id", false), ctx).apply(qb);
        }
        Page torrentEntityPage = this.torrentDao.queryByPaging(qb, pageable);
        ArrayList<TorrentInfoDTO> infoList = new ArrayList<TorrentInfoDTO>();
        for (TorrentEntity result : torrentEntityPage.getResults()) {
            long peerBanCount = this.historyDao.queryBuilder().where().eq("torrent_id", (Object)result.getId()).countOf();
            long peerAccessCount = this.peerRecordDao.queryBuilder().where().eq("torrent_id", (Object)result.getId()).countOf();
            infoList.add(new TorrentInfoDTO(result.getInfoHash(), result.getName(), result.getSize(), peerBanCount, peerAccessCount));
        }
        ctx.json((Object)new StdResp(true, null, new Page(pageable, torrentEntityPage.getTotal(), infoList)));
    }

    private void handleTorrentInfo(Context ctx) throws SQLException {
        Optional<TorrentEntity> torrent = this.torrentDao.queryByInfoHash(ctx.pathParam("infoHash"));
        if (torrent.isEmpty()) {
            ctx.status(404);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.TORRENT_NOT_FOUND, new Object[0]), null));
            return;
        }
        TorrentEntity t = torrent.get();
        long peerBanCount = this.historyDao.queryBuilder().where().eq("torrent_id", (Object)t.getId()).countOf();
        long peerAccessCount = this.peerRecordDao.queryBuilder().orderBy("lastTimeSeen", false).where().eq("torrent_id", (Object)t.getId()).countOf();
        ctx.json((Object)new StdResp(true, null, new TorrentInfoDTO(t.getInfoHash(), t.getName(), t.getSize(), peerBanCount, peerAccessCount)));
    }

    private void handleConnectHistory(Context ctx) throws SQLException {
        Optional<TorrentEntity> torrent = this.torrentDao.queryByInfoHash(ctx.pathParam("infoHash"));
        if (torrent.isEmpty()) {
            ctx.status(404);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.TORRENT_NOT_FOUND, new Object[0]), null));
            return;
        }
        Pageable pageable = new Pageable(ctx);
        TorrentEntity t = torrent.get();
        QueryBuilder queryBuilder = new Orderable(Map.of("lastTimeSeen", false, "address", true, "port", true), ctx).addMapping("torrent.name", "torrentName").addMapping("torrent.infoHash", "torrentInfoHash").addMapping("torrent.size", "torrentSize").addMapping("ip", "peerIp").apply(this.peerRecordDao.queryBuilder().join(this.torrentDao.queryBuilder(), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND));
        queryBuilder.where().eq("torrent_id", (Object)t);
        Page page = this.peerRecordDao.queryByPaging(queryBuilder, pageable);
        ctx.json((Object)new StdResp(true, null, Page.map(page, entity -> new PeerRecordEntityDTO(entity.getId(), entity.getAddress(), entity.getPort(), TorrentEntityDTO.from(entity.getTorrent()), this.downloaderManager.getDownloadInfo(entity.getDownloader()), entity.getPeerId(), entity.getClientName(), entity.getUploaded(), entity.getUploadedOffset(), entity.getUploadSpeed(), entity.getDownloaded(), entity.getDownloadedOffset(), entity.getDownloadSpeed(), entity.getLastFlags(), entity.getFirstTimeSeen(), entity.getLastTimeSeen()))));
    }

    @Override
    public void onDisable() {
    }
}

