/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.json;

import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.TimestampTypeAdapter;
import com.ghostchu.peerbanhelper.util.json.TranslationComponentTypeAdapter;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.sql.Timestamp;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class JsonUtil {
    private static final Gson DEFAULT_GSON = new Gson();
    private static final Gson STANDARD_GSON = new GsonBuilder().enableComplexMapKeySerialization().setExclusionStrategies(new ExclusionStrategy[]{new HiddenAnnotationExclusionStrategy()}).serializeNulls().registerTypeAdapter(Timestamp.class, (Object)TimestampTypeAdapter.INSTANCE).registerTypeAdapter(TranslationComponent.class, (Object)TranslationComponentTypeAdapter.INSTANCE).disableHtmlEscaping().create();
    private static final Gson TINY_JSON = new GsonBuilder().enableComplexMapKeySerialization().setExclusionStrategies(new ExclusionStrategy[]{new HiddenAnnotationExclusionStrategy()}).registerTypeAdapter(Timestamp.class, (Object)TimestampTypeAdapter.INSTANCE).registerTypeAdapter(TranslationComponent.class, (Object)TranslationComponentTypeAdapter.INSTANCE).disableHtmlEscaping().create();

    @Deprecated
    @NotNull
    public static Gson get() {
        return JsonUtil.standard();
    }

    @NotNull
    public static Gson standard() {
        return STANDARD_GSON;
    }

    public static Gson tiny() {
        return TINY_JSON;
    }

    public static Gson getGson() {
        return STANDARD_GSON;
    }

    @NotNull
    public static JsonObject readObject(@NotNull String s) {
        return JsonParser.parseString((String)s).getAsJsonObject();
    }

    public static Gson regular() {
        return STANDARD_GSON;
    }

    @NotNull
    public static String toString(@NotNull JsonElement element) {
        return Objects.requireNonNull(JsonUtil.standard().toJson(element));
    }

    public static void writeElement(@NotNull Appendable writer, @NotNull JsonElement element) {
        JsonUtil.standard().toJson(element, writer);
    }

    public static void writeObject(@NotNull Appendable writer, @NotNull JsonObject object) {
        JsonUtil.standard().toJson((JsonElement)object, writer);
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(Hidden.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.getDeclaredAnnotation(Hidden.class) != null;
        }
    }

    public static @interface Hidden {
    }
}

