/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push.impl;

import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;

public final class BarkPushProvider
extends AbstractPushProvider {
    private final Config config;
    private final String name;
    private final HTTPUtil httpUtil;

    public BarkPushProvider(String name, Config config, HTTPUtil httpUtil) {
        this.name = name;
        this.config = config;
        this.httpUtil = httpUtil;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigType() {
        return "bark";
    }

    @Override
    public JsonObject saveJson() {
        return JsonUtil.readObject(JsonUtil.standard().toJson((Object)this.config));
    }

    @Override
    public ConfigurationSection saveYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"bark");
        section.set("backend_url", (Object)this.config.getBackendUrl());
        section.set("device_key", (Object)this.config.getDeviceKey());
        section.set("message_group", (Object)this.config.getMessageGroup());
        return section;
    }

    public static BarkPushProvider loadFromJson(String name, JsonObject json, HTTPUtil httpUtil) {
        return new BarkPushProvider(name, (Config)JsonUtil.getGson().fromJson((JsonElement)json, Config.class), httpUtil);
    }

    public static BarkPushProvider loadFromYaml(String name, ConfigurationSection section, HTTPUtil httpUtil) {
        String backendUrl = section.getString("backend_url", "https://api.day.app/push");
        String sendKey = section.getString("device_key", "");
        String group = section.getString("message_group", "");
        Config config = new Config(backendUrl, sendKey, group);
        return new BarkPushProvider(name, config, httpUtil);
    }

    @Override
    public boolean push(String title, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("body", content);
        map.put("device_key", this.config.getDeviceKey());
        map.put("group", this.config.getMessageGroup());
        map.put("icon", "https://raw.githubusercontent.com/PBH-BTN/PeerBanHelper/refs/heads/master/src/main/resources/assets/icon.png");
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson(map), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(this.config.getBackendUrl()).post(requestBody).header("Content-Type", "application/json").build();
        try (Response response = this.httpUtil.newBuilder().build().newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalStateException("HTTP Failed while sending push messages to Bark: " + response.body().string());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send push message to Bark", e);
        }
        return true;
    }

    public static class Config {
        @SerializedName(value="backend_url")
        private String backendUrl;
        @SerializedName(value="device_key")
        private String deviceKey;
        @SerializedName(value="message_group")
        private String messageGroup;

        @Generated
        public Config(String backendUrl, String deviceKey, String messageGroup) {
            this.backendUrl = backendUrl;
            this.deviceKey = deviceKey;
            this.messageGroup = messageGroup;
        }

        @Generated
        public String getBackendUrl() {
            return this.backendUrl;
        }

        @Generated
        public String getDeviceKey() {
            return this.deviceKey;
        }

        @Generated
        public String getMessageGroup() {
            return this.messageGroup;
        }

        @Generated
        public void setBackendUrl(String backendUrl) {
            this.backendUrl = backendUrl;
        }

        @Generated
        public void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        @Generated
        public void setMessageGroup(String messageGroup) {
            this.messageGroup = messageGroup;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$backendUrl = this.getBackendUrl();
            String other$backendUrl = other.getBackendUrl();
            if (this$backendUrl == null ? other$backendUrl != null : !this$backendUrl.equals(other$backendUrl)) {
                return false;
            }
            String this$deviceKey = this.getDeviceKey();
            String other$deviceKey = other.getDeviceKey();
            if (this$deviceKey == null ? other$deviceKey != null : !this$deviceKey.equals(other$deviceKey)) {
                return false;
            }
            String this$messageGroup = this.getMessageGroup();
            String other$messageGroup = other.getMessageGroup();
            return !(this$messageGroup == null ? other$messageGroup != null : !this$messageGroup.equals(other$messageGroup));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $backendUrl = this.getBackendUrl();
            result = result * 59 + ($backendUrl == null ? 43 : $backendUrl.hashCode());
            String $deviceKey = this.getDeviceKey();
            result = result * 59 + ($deviceKey == null ? 43 : $deviceKey.hashCode());
            String $messageGroup = this.getMessageGroup();
            result = result * 59 + ($messageGroup == null ? 43 : $messageGroup.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BarkPushProvider.Config(backendUrl=" + this.getBackendUrl() + ", deviceKey=" + this.getDeviceKey() + ", messageGroup=" + this.getMessageGroup() + ")";
        }
    }
}

