/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.traversal.btstun;

import com.cdnbye.core.nat.NatType;
import com.cdnbye.core.nat.NettyStunClient;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StunManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StunManager.class);
    private NatType cachedNatType = NatType.Unknown;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, Thread.ofVirtual().factory());

    public StunManager() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshNatType, 0L, 1L, TimeUnit.HOURS);
    }

    @NotNull
    public NatType getCachedNatType() {
        return this.cachedNatType;
    }

    @NotNull
    public NatType refreshNatType() {
        List stunServers = Main.getMainConfig().getStringList("stun.udp-servers");
        ArrayList shuffledServers = new ArrayList(stunServers);
        Collections.shuffle(shuffledServers);
        for (String stunServer : shuffledServers) {
            String[] stun = stunServer.split(":");
            if (stun.length != 2) {
                log.debug("Invalid STUN server format: {}, skipping", (Object)stunServer);
                continue;
            }
            try {
                NatType natType = NettyStunClient.query(stun[0], Integer.parseInt(stun[1]), "0.0.0.0").natType();
                if (natType != NatType.Unknown && natType != NatType.UdpBlocked) {
                    this.cachedNatType = natType;
                    log.debug("Successfully determined NAT type {} using server {}", (Object)natType, (Object)stunServer);
                    return this.cachedNatType;
                }
                log.debug("STUN server {} returned Unknown NAT type, trying next server", (Object)stunServer);
            }
            catch (Exception e) {
                log.debug("Failed to query STUN server {}: {}, trying next server", (Object)stunServer, (Object)e.getMessage());
            }
        }
        log.error(TextManager.tlUI(Lang.AUTOSTUN_STUN_SERVICE_UNAVAILABLE, new Object[0]));
        this.cachedNatType = NatType.UdpBlocked;
        return this.cachedNatType;
    }

    @Override
    public void close() {
        if (!this.scheduledExecutorService.isShutdown()) {
            this.scheduledExecutorService.shutdown();
        }
    }
}

