/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.GnomeThemeDetector;
import com.jthemedetecor.MacOSThemeDetector;
import com.jthemedetecor.WindowsThemeDetector;
import com.jthemedetecor.util.OsInfo;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;

public abstract class OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(OsThemeDetector.class);
    private static volatile OsThemeDetector osThemeDetector;

    OsThemeDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    @ThreadSafe
    public static OsThemeDetector getDetector() {
        OsThemeDetector instance = osThemeDetector;
        if (instance != null) return instance;
        Class<OsThemeDetector> clazz = OsThemeDetector.class;
        synchronized (OsThemeDetector.class) {
            instance = osThemeDetector;
            if (instance != null) return instance;
            osThemeDetector = instance = OsThemeDetector.createDetector();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static OsThemeDetector createDetector() {
        if (OsInfo.isWindows10OrLater()) {
            OsThemeDetector.logDetection("Windows 10", WindowsThemeDetector.class);
            return new WindowsThemeDetector();
        }
        if (OsInfo.isGnome()) {
            OsThemeDetector.logDetection("Gnome", GnomeThemeDetector.class);
            return new GnomeThemeDetector();
        }
        if (OsInfo.isMacOsMojaveOrLater()) {
            OsThemeDetector.logDetection("MacOS", MacOSThemeDetector.class);
            return new MacOSThemeDetector();
        }
        logger.debug("Theme detection is not supported on the system: {} {}", (Object)OsInfo.getFamily(), (Object)OsInfo.getVersion());
        logger.debug("Creating empty detector...");
        return new EmptyDetector();
    }

    private static void logDetection(String desktop, Class<? extends OsThemeDetector> detectorClass) {
        logger.debug("Supported Desktop detected: {}", (Object)desktop);
        logger.debug("Creating {}...", (Object)detectorClass.getName());
    }

    @ThreadSafe
    public abstract boolean isDark();

    @ThreadSafe
    public abstract void registerListener(@NotNull Consumer<Boolean> var1);

    @ThreadSafe
    public abstract void removeListener(@Nullable Consumer<Boolean> var1);

    @ThreadSafe
    public static boolean isSupported() {
        return OsInfo.isWindows10OrLater() || OsInfo.isMacOsMojaveOrLater() || OsInfo.isGnome();
    }

    private static final class EmptyDetector
    extends OsThemeDetector {
        private EmptyDetector() {
        }

        @Override
        public boolean isDark() {
            return false;
        }

        @Override
        public void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        }

        @Override
        public void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        }
    }
}

