/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.VersionParser;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;

public class Version
implements Comparable<Version>,
Serializable {
    public static final Comparator<Version> INCREMENT_ORDER = Version::compareToIgnoreBuildMetadata;
    public static final Comparator<Version> PRECEDENCE_ORDER = INCREMENT_ORDER.reversed();
    private final long major;
    private final long minor;
    private final long patch;
    private final String[] preReleaseIds;
    private final String[] buildIds;
    private static final String IDENTIFIER_SEPARATOR = ".";
    private static final String PRE_RELEASE_PREFIX = "-";
    private static final String BUILD_PREFIX = "+";
    @Deprecated
    public static final Comparator<Version> BUILD_AWARE_ORDER = Version::compareTo;

    Version(long major, long minor, long patch) {
        this(major, minor, patch, new String[0], new String[0]);
    }

    Version(long major, long minor, long patch, String[] preReleaseIds) {
        this(major, minor, patch, preReleaseIds, new String[0]);
    }

    Version(long major, long minor, long patch, String[] preReleaseIds, String[] buildIds) {
        this.major = Validators.nonNegative(major, "major");
        this.minor = Validators.nonNegative(minor, "minor");
        this.patch = Validators.nonNegative(patch, "patch");
        this.preReleaseIds = (String[])Validators.nonNull(preReleaseIds, "preReleaseIds").clone();
        this.buildIds = (String[])Validators.nonNull(buildIds, "buildIds").clone();
    }

    public static Version parse(String version) {
        return Version.parse(version, true);
    }

    public static Version parse(String version, boolean strictly) {
        return VersionParser.parseValidSemVer(Validators.nonNull(version, "version"), strictly);
    }

    public static Optional<Version> tryParse(String version) {
        return Version.tryParse(version, true);
    }

    public static Optional<Version> tryParse(String version, boolean strictly) {
        try {
            return Optional.of(Version.parse(version, strictly));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public static boolean isValid(String version) {
        return Version.isValid(version, true);
    }

    public static boolean isValid(String version, boolean strictly) {
        return Version.tryParse(version, strictly).isPresent();
    }

    public static Version of(long major) {
        return Version.of(major, 0L, 0L, null, null);
    }

    public static Version of(long major, String preRelease) {
        return Version.of(major, 0L, 0L, preRelease, null);
    }

    public static Version of(long major, String preRelease, String build) {
        return Version.of(major, 0L, 0L, preRelease, build);
    }

    public static Version of(long major, long minor) {
        return Version.of(major, minor, 0L, null, null);
    }

    public static Version of(long major, long minor, String preRelease) {
        return Version.of(major, minor, 0L, preRelease, null);
    }

    public static Version of(long major, long minor, String preRelease, String build) {
        return Version.of(major, minor, 0L, preRelease, build);
    }

    public static Version of(long major, long minor, long patch) {
        return Version.of(major, minor, patch, null, null);
    }

    public static Version of(long major, long minor, long patch, String preRelease) {
        return Version.of(major, minor, patch, preRelease, null);
    }

    public static Version of(long major, long minor, long patch, String preRelease, String build) {
        return new Version(major, minor, patch, preRelease == null ? new String[]{} : VersionParser.parsePreRelease(preRelease), build == null ? new String[]{} : VersionParser.parseBuild(build));
    }

    public long majorVersion() {
        return this.major;
    }

    public long minorVersion() {
        return this.minor;
    }

    public long patchVersion() {
        return this.patch;
    }

    public Optional<String> preReleaseVersion() {
        return Optional.ofNullable(Version.joinIdentifiers(this.preReleaseIds));
    }

    public Optional<String> buildMetadata() {
        return Optional.ofNullable(Version.joinIdentifiers(this.buildIds));
    }

    public Version nextMajorVersion(String ... preReleaseIds) {
        return this.nextMajorVersion(Version.safeIncrement(this.major), preReleaseIds);
    }

    public Version nextMajorVersion(long major, String ... preReleaseIds) {
        if (this.major >= Validators.nonNegative(major, "major")) {
            throw new IllegalStateException("This major version is higher or equivalent");
        }
        String preRelease = Version.joinIdentifiers(Validators.zeroOrMoreNonNulls(preReleaseIds, "preReleaseIds"));
        return Version.of(major, 0L, 0L, preRelease);
    }

    public Version nextMinorVersion(String ... preReleaseIds) {
        return this.nextMinorVersion(Version.safeIncrement(this.minor), preReleaseIds);
    }

    public Version nextMinorVersion(long minor, String ... preReleaseIds) {
        if (this.minor >= Validators.nonNegative(minor, "minor")) {
            throw new IllegalStateException("This minor version is higher or equivalent");
        }
        String preRelease = Version.joinIdentifiers(Validators.zeroOrMoreNonNulls(preReleaseIds, "preReleaseIds"));
        return Version.of(this.major, minor, 0L, preRelease);
    }

    public Version nextPatchVersion(String ... preReleaseIds) {
        return this.nextPatchVersion(Version.safeIncrement(this.patch), preReleaseIds);
    }

    public Version nextPatchVersion(long patch, String ... preReleaseIds) {
        if (this.patch >= Validators.nonNegative(patch, "patch")) {
            throw new IllegalStateException("This patch version is higher or equivalent");
        }
        String preRelease = Version.joinIdentifiers(Validators.zeroOrMoreNonNulls(preReleaseIds, "preReleaseIds"));
        return Version.of(this.major, this.minor, patch, preRelease);
    }

    public Version nextPreReleaseVersion(String ... ids) {
        String[] newPreReleaseIds;
        if (!this.isPreRelease()) {
            throw new IllegalStateException("Not a pre-release version");
        }
        Validators.zeroOrMoreNonNulls(ids, "ids");
        if (ids.length > 0) {
            newPreReleaseIds = VersionParser.parsePreRelease(Version.joinIdentifiers(ids));
            if (Version.compareIdentifierArrays(this.preReleaseIds, newPreReleaseIds) >= 0) {
                throw new IllegalStateException("This pre-release version is higher or equivalent");
            }
        } else {
            newPreReleaseIds = Version.incrementIdentifiers(this.preReleaseIds);
        }
        return new Version(this.major, this.minor, this.patch, newPreReleaseIds);
    }

    public Version toStableVersion() {
        return this.isStable() ? this : new Version(this.major, this.minor, this.patch);
    }

    public Version withBuildMetadata(String ... ids) {
        String[] newBuildIds = VersionParser.parseBuild(Version.joinIdentifiers(Validators.oneOrMoreNonNulls(ids, "ids")));
        return new Version(this.major, this.minor, this.patch, this.preReleaseIds, newBuildIds);
    }

    public Version withoutBuildMetadata() {
        return !this.buildMetadata().isPresent() ? this : new Version(this.major, this.minor, this.patch, this.preReleaseIds);
    }

    public boolean satisfies(Predicate<Version> predicate) {
        return Validators.nonNull(predicate, "predicate").test(this);
    }

    public boolean satisfies(String expr) {
        Parser<Expression> parser = ExpressionParser.newInstance();
        return this.satisfies(parser.parse(Validators.nonNull(expr, "expr")));
    }

    public boolean isPreRelease() {
        return this.preReleaseVersion().isPresent();
    }

    public boolean isStable() {
        return !this.isPreRelease();
    }

    public boolean isPublicApiStable() {
        return this.isHigherThanOrEquivalentTo(Version.of(1L));
    }

    public boolean isPublicApiCompatibleWith(Version other) {
        return this.isPublicApiStable() && this.isSameMajorVersionAs(other);
    }

    public boolean isSameMajorVersionAs(Version other) {
        Validators.nonNull(other, "other");
        return this.major == other.major;
    }

    public boolean isSameMinorVersionAs(Version other) {
        Validators.nonNull(other, "other");
        return this.major == other.major && this.minor == other.minor;
    }

    public boolean isSamePatchVersionAs(Version other) {
        Validators.nonNull(other, "other");
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public boolean isHigherThan(Version other) {
        return this.compareToIgnoreBuildMetadata(other) > 0;
    }

    public boolean isHigherThanOrEquivalentTo(Version other) {
        return this.compareToIgnoreBuildMetadata(other) >= 0;
    }

    public boolean isLowerThan(Version other) {
        return this.compareToIgnoreBuildMetadata(other) < 0;
    }

    public boolean isLowerThanOrEquivalentTo(Version other) {
        return this.compareToIgnoreBuildMetadata(other) <= 0;
    }

    public boolean isEquivalentTo(Version other) {
        return this.compareToIgnoreBuildMetadata(other) == 0;
    }

    @Override
    public int compareTo(Version other) {
        int result = this.compareToIgnoreBuildMetadata(other);
        if (result != 0) {
            return result;
        }
        result = Version.compareIdentifierArrays(this.buildIds, other.buildIds);
        if (this.buildIds.length == 0 || other.buildIds.length == 0) {
            result = -1 * result;
        }
        return result;
    }

    public int compareToIgnoreBuildMetadata(Version other) {
        Validators.nonNull(other, "other");
        long result = this.major - other.major;
        if (result == 0L && (result = this.minor - other.minor) == 0L && (result = this.patch - other.patch) == 0L) {
            return Version.compareIdentifierArrays(this.preReleaseIds, other.preReleaseIds);
        }
        return result < 0L ? -1 : 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Long.hashCode(this.major);
        hash = 97 * hash + Long.hashCode(this.minor);
        hash = 97 * hash + Long.hashCode(this.patch);
        hash = 97 * hash + Arrays.hashCode(this.preReleaseIds);
        hash = 97 * hash + Arrays.hashCode(this.buildIds);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(IDENTIFIER_SEPARATOR);
        sb.append(this.minor);
        sb.append(IDENTIFIER_SEPARATOR);
        sb.append(this.patch);
        this.preReleaseVersion().ifPresent(r -> sb.append(PRE_RELEASE_PREFIX).append((String)r));
        this.buildMetadata().ifPresent(b -> sb.append(BUILD_PREFIX).append((String)b));
        return sb.toString();
    }

    public Builder toBuilder() {
        Builder b = new Builder();
        b.setVersionCore(this.major, this.minor, this.patch);
        this.preReleaseVersion().ifPresent(xva$0 -> b.setPreReleaseVersion((String)xva$0));
        this.buildMetadata().ifPresent(xva$0 -> b.setBuildMetadata((String)xva$0));
        return b;
    }

    private static long safeIncrement(long l) {
        return Math.incrementExact(l);
    }

    private static String joinIdentifiers(String ... ids) {
        return ids.length == 0 ? null : String.join((CharSequence)IDENTIFIER_SEPARATOR, ids);
    }

    private static String[] incrementIdentifiers(String[] ids) {
        String[] newIds;
        String lastId = ids[ids.length - 1];
        if (Version.isNumeric(lastId)) {
            newIds = Arrays.copyOf(ids, ids.length);
            newIds[newIds.length - 1] = String.valueOf(Version.safeIncrement(Long.parseLong(lastId)));
        } else {
            newIds = Arrays.copyOf(ids, ids.length + 1);
            newIds[newIds.length - 1] = String.valueOf(1);
        }
        return newIds;
    }

    private static int compareIdentifierArrays(String[] thisIds, String[] otherIds) {
        if (thisIds.length == 0 && otherIds.length == 0) {
            return 0;
        }
        if (thisIds.length == 0 || otherIds.length == 0) {
            return thisIds.length == 0 ? 1 : -1;
        }
        int result = 0;
        int minLength = Math.min(thisIds.length, otherIds.length);
        for (int i = 0; i < minLength && (result = Version.compareIdentifiers(thisIds[i], otherIds[i])) == 0; ++i) {
        }
        if (result == 0) {
            result = thisIds.length - otherIds.length;
        }
        return result;
    }

    private static int compareIdentifiers(String thisId, String otherId) {
        if (Version.isNumeric(thisId) && Version.isNumeric(otherId)) {
            return Long.valueOf(thisId).compareTo(Long.valueOf(otherId));
        }
        return thisId.compareTo(otherId);
    }

    private static boolean isNumeric(String id) {
        if (id.startsWith("0")) {
            return false;
        }
        return id.chars().allMatch(Character::isDigit);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    @Deprecated
    public static Version valueOf(String version) {
        return Version.parse(version);
    }

    @Deprecated
    public static Version forIntegers(int major) {
        return Version.of(major);
    }

    @Deprecated
    public static Version forIntegers(int major, int minor) {
        return Version.of((long)major, minor);
    }

    @Deprecated
    public static Version forIntegers(int major, int minor, int patch) {
        return Version.of((long)major, (long)minor, patch);
    }

    @Deprecated
    public String getNormalVersion() {
        return String.format(Locale.ROOT, "%d.%d.%d", this.major, this.minor, this.patch);
    }

    @Deprecated
    public int getMajorVersion() {
        long major = this.majorVersion();
        if (major > Integer.MAX_VALUE) {
            throw new RuntimeException("major > Integer.MAX_VALUE");
        }
        return (int)major;
    }

    @Deprecated
    public int getMinorVersion() {
        long minor = this.minorVersion();
        if (minor > Integer.MAX_VALUE) {
            throw new RuntimeException("minor > Integer.MAX_VALUE");
        }
        return (int)minor;
    }

    @Deprecated
    public int getPatchVersion() {
        long patch = this.patchVersion();
        if (patch > Integer.MAX_VALUE) {
            throw new RuntimeException("patch > Integer.MAX_VALUE");
        }
        return (int)patch;
    }

    @Deprecated
    public String getPreReleaseVersion() {
        return this.preReleaseVersion().orElse("");
    }

    @Deprecated
    public String getBuildMetadata() {
        return this.buildMetadata().orElse("");
    }

    @Deprecated
    public Version setPreReleaseVersion(String preRelease) {
        return new Version(this.major, this.minor, this.patch, VersionParser.parsePreRelease(preRelease));
    }

    @Deprecated
    public Version setBuildMetadata(String build) {
        return this.withBuildMetadata(build);
    }

    @Deprecated
    public Version incrementMajorVersion() {
        return this.nextMajorVersion(new String[0]);
    }

    @Deprecated
    public Version incrementMajorVersion(String preRelease) {
        return this.nextMajorVersion(preRelease);
    }

    @Deprecated
    public Version incrementMinorVersion() {
        return this.nextMinorVersion(new String[0]);
    }

    @Deprecated
    public Version incrementMinorVersion(String preRelease) {
        return this.nextMinorVersion(preRelease);
    }

    @Deprecated
    public Version incrementPatchVersion() {
        return this.nextPatchVersion(new String[0]);
    }

    @Deprecated
    public Version incrementPatchVersion(String preRelease) {
        return this.nextPatchVersion(preRelease);
    }

    @Deprecated
    public Version incrementPreReleaseVersion() {
        return this.nextPreReleaseVersion(new String[0]);
    }

    @Deprecated
    public Version incrementBuildMetadata() {
        if (!this.buildMetadata().isPresent()) {
            throw new IllegalStateException("Build metadata empty");
        }
        return new Version(this.major, this.minor, this.patch, this.preReleaseIds, Version.incrementIdentifiers(this.buildIds));
    }

    @Deprecated
    public boolean greaterThan(Version other) {
        return this.isHigherThan(other);
    }

    @Deprecated
    public boolean greaterThanOrEqualTo(Version other) {
        return this.isHigherThanOrEquivalentTo(other);
    }

    @Deprecated
    public boolean lessThan(Version other) {
        return this.isLowerThan(other);
    }

    @Deprecated
    public boolean lessThanOrEqualTo(Version other) {
        return this.isLowerThanOrEquivalentTo(other);
    }

    @Deprecated
    public int compareWithBuildsTo(Version other) {
        return this.compareTo(other);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String version;

        SerializationProxy(Version version) {
            this.version = version.toString();
        }

        private Object readResolve() {
            return Version.parse(this.version);
        }
    }

    static class Validators {
        Validators() {
        }

        static long nonNegative(long arg, String name) {
            if (arg < 0L) {
                throw new IllegalArgumentException(name + " must not be negative");
            }
            return arg;
        }

        static <T> T nonNull(T arg, String name) {
            return Validators.nonNullOrThrow(arg, name + " must not be null");
        }

        static <T> T[] nonEmpty(T[] arg, String name) {
            if (Validators.nonNull(arg, name).length == 0) {
                throw new IllegalArgumentException(name + " must not be empty");
            }
            return arg;
        }

        static <T> T[] zeroOrMoreNonNulls(T[] arg, String name) {
            for (T t : Validators.nonNull(arg, name)) {
                Validators.nonNullOrThrow(t, name + " must not contain null");
            }
            return arg;
        }

        static <T> T[] oneOrMoreNonNulls(T[] arg, String name) {
            for (T t : Validators.nonEmpty(arg, name)) {
                Validators.nonNullOrThrow(t, name + " must not contain null");
            }
            return arg;
        }

        private static <T> T nonNullOrThrow(T arg, String msg) {
            if (arg == null) {
                throw new IllegalArgumentException(msg);
            }
            return arg;
        }
    }

    public static class Builder {
        private long major = 0L;
        private long minor = 0L;
        private long patch = 0L;
        private String[] preReleaseIds = new String[0];
        private String[] buildIds = new String[0];

        public Builder() {
        }

        public Builder setVersionCore(long major) {
            return this.setVersionCore(major, 0L, 0L);
        }

        public Builder setVersionCore(long major, long minor) {
            return this.setVersionCore(major, minor, 0L);
        }

        public Builder setVersionCore(long major, long minor, long patch) {
            return this.setMajorVersion(major).setMinorVersion(minor).setPatchVersion(patch);
        }

        public Builder setMajorVersion(long major) {
            this.major = Validators.nonNegative(major, "major");
            return this;
        }

        public Builder setMinorVersion(long minor) {
            this.minor = Validators.nonNegative(minor, "minor");
            return this;
        }

        public Builder setPatchVersion(long patch) {
            this.patch = Validators.nonNegative(patch, "patch");
            return this;
        }

        public Builder setPreReleaseVersion(String ... ids) {
            this.preReleaseIds = (String[])Validators.oneOrMoreNonNulls(ids, "ids").clone();
            return this;
        }

        public Builder addPreReleaseIdentifiers(String ... ids) {
            if (this.preReleaseIds.length == 0) {
                return this.setPreReleaseVersion(ids);
            }
            this.preReleaseIds = Builder.concatArrays(this.preReleaseIds, Validators.oneOrMoreNonNulls(ids, "ids"));
            return this;
        }

        public Builder unsetPreReleaseVersion() {
            this.preReleaseIds = new String[0];
            return this;
        }

        public Builder setBuildMetadata(String ... ids) {
            this.buildIds = (String[])Validators.oneOrMoreNonNulls(ids, "ids").clone();
            return this;
        }

        public Builder addBuildIdentifiers(String ... ids) {
            if (this.buildIds.length == 0) {
                return this.setBuildMetadata(ids);
            }
            this.buildIds = Builder.concatArrays(this.buildIds, Validators.oneOrMoreNonNulls(ids, "ids"));
            return this;
        }

        public Builder unsetBuildMetadata() {
            this.buildIds = new String[0];
            return this;
        }

        public Version build() {
            return Version.of(this.major, this.minor, this.patch, Version.joinIdentifiers(this.preReleaseIds), Version.joinIdentifiers(this.buildIds));
        }

        private static String[] concatArrays(String[] ids1, String[] ids2) {
            String[] ids = new String[ids1.length + ids2.length];
            System.arraycopy(ids1, 0, ids, 0, ids1.length);
            System.arraycopy(ids2, 0, ids, ids1.length, ids2.length);
            return ids;
        }

        @Deprecated
        public Builder(String normal) {
            this.setNormalVersion(normal);
        }

        @Deprecated
        public Builder setNormalVersion(String normal) {
            String[] parts = Validators.nonNull(normal, "normal").split("\\.");
            return this.setVersionCore(Long.parseLong(parts[0]), parts.length > 1 ? Long.parseLong(parts[1]) : 0L, parts.length > 2 ? Long.parseLong(parts[2]) : 0L);
        }
    }
}

