/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database;

import com.ghostchu.peerbanhelper.config.ConfigTransfer;
import com.ghostchu.peerbanhelper.database.Database;
import com.ghostchu.peerbanhelper.database.PBHTableUtils;
import com.ghostchu.peerbanhelper.database.table.AlertEntity;
import com.ghostchu.peerbanhelper.database.table.BanListEntity;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.database.table.MetadataEntity;
import com.ghostchu.peerbanhelper.database.table.ModuleEntity;
import com.ghostchu.peerbanhelper.database.table.PCBAddressEntity;
import com.ghostchu.peerbanhelper.database.table.PCBRangeEntity;
import com.ghostchu.peerbanhelper.database.table.PeerConnectionMetricsEntity;
import com.ghostchu.peerbanhelper.database.table.PeerConnectionMetricsTrackEntity;
import com.ghostchu.peerbanhelper.database.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.database.table.RuleEntity;
import com.ghostchu.peerbanhelper.database.table.RuleSubInfoEntity;
import com.ghostchu.peerbanhelper.database.table.RuleSubLogEntity;
import com.ghostchu.peerbanhelper.database.table.TorrentEntity;
import com.ghostchu.peerbanhelper.database.table.TrafficJournalEntity;
import com.ghostchu.peerbanhelper.database.table.tmp.TrackedSwarmEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.logger.Level;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class DatabaseHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseHelper.class);
    private final Database database;

    public DatabaseHelper(@Autowired Database database) throws SQLException {
        this.database = database;
        com.j256.ormlite.logger.Logger.setGlobalLogLevel((Level)Level.WARNING);
        this.createTables(true);
        this.performUpgrade();
        this.createTables(false);
    }

    private void createTables(boolean ignoreError) {
        Class[] persistTable = new Class[]{MetadataEntity.class, TorrentEntity.class, ModuleEntity.class, RuleEntity.class, HistoryEntity.class, BanListEntity.class, RuleSubInfoEntity.class, RuleSubLogEntity.class, PeerRecordEntity.class, PCBAddressEntity.class, PCBRangeEntity.class, TrafficJournalEntity.class, AlertEntity.class, PeerConnectionMetricsEntity.class, PeerConnectionMetricsTrackEntity.class};
        Class[] tempTable = new Class[]{TrackedSwarmEntity.class};
        this.performCreateTables(persistTable, ignoreError, false);
        this.performCreateTables(tempTable, ignoreError, true);
    }

    private void performCreateTables(Class<?>[] table, boolean ignoreError, boolean tempTable) {
        for (Class<?> aClass : table) {
            try {
                PBHTableUtils.createTableIfNotExists((ConnectionSource)this.database.getDataSource(), aClass, tempTable, ignoreError);
            }
            catch (Exception err) {
                if (ignoreError) continue;
                log.error("Unable to create table for class: " + aClass.getSimpleName(), (Throwable)err);
            }
        }
    }

    private void performUpgrade() throws SQLException {
        Dao historyDao;
        Dao metadata = DaoManager.createDao((ConnectionSource)this.getDataSource(), MetadataEntity.class);
        MetadataEntity version = (MetadataEntity)metadata.createIfNotExists((Object)new MetadataEntity("version", "20"));
        int v = Integer.parseInt(version.getValue());
        if (v < 3) {
            try {
                historyDao = DaoManager.createDao((ConnectionSource)this.getDataSource(), HistoryEntity.class);
                historyDao.executeRaw("ALTER TABLE " + historyDao.getTableName() + " ADD COLUMN downloader VARCHAR DEFAULT ''", new String[0]);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 3;
        }
        if (v == 3) {
            v = 4;
        }
        if (v == 4) {
            v = 5;
        }
        if (v == 5) {
            v = 6;
        }
        if (v == 6) {
            TableUtils.dropTable((ConnectionSource)this.getDataSource(), AlertEntity.class, (boolean)true);
            TableUtils.createTableIfNotExists((ConnectionSource)this.database.getDataSource(), AlertEntity.class);
            v = 7;
        }
        if (v == 7) {
            TableUtils.dropTable((ConnectionSource)this.getDataSource(), AlertEntity.class, (boolean)true);
            TableUtils.createTableIfNotExists((ConnectionSource)this.database.getDataSource(), AlertEntity.class);
            v = 8;
        }
        if (v == 8) {
            try {
                Dao torrentDao = DaoManager.createDao((ConnectionSource)this.getDataSource(), TorrentEntity.class);
                torrentDao.executeRaw("ALTER TABLE " + torrentDao.getTableName() + " ADD COLUMN privateTorrent BOOLEAN NULL", new String[0]);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 9;
        }
        if (v == 9) {
            try {
                historyDao = DaoManager.createDao((ConnectionSource)this.getDataSource(), HistoryEntity.class);
                historyDao.executeRaw("ALTER TABLE " + historyDao.getTableName() + " ADD COLUMN downloaderProgress DOUBLE NULL", new String[0]);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 10;
        }
        if (v == 10) {
            try {
                this.database.getDataSource().getReadWriteConnection("peer_records").executeStatement("ALTER TABLE peer_records ADD COLUMN uploadSpeed BIGINT NOT NULL DEFAULT 0", -1);
                this.database.getDataSource().getReadWriteConnection("peer_records").executeStatement("ALTER TABLE peer_records ADD COLUMN downloadSpeed BIGINT NOT NULL DEFAULT 0", -1);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 11;
        }
        if (v <= 14) {
            try {
                this.database.getDataSource().getReadWriteConnection("history").executeStatement("ALTER TABLE history ADD COLUMN structuredData TEXT NOT NULL DEFAULT '{}'", -1);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 15;
        }
        if (v == 15) {
            try {
                historyDao = DaoManager.createDao((ConnectionSource)this.getDataSource(), HistoryEntity.class);
                this.recordBatchUpdate("DownloaderName Converting (BanHistory)", historyDao, historyEntity -> {
                    String downloaderName = historyEntity.getDownloader();
                    historyEntity.setDownloader(ConfigTransfer.downloaderNameToUUID.getOrDefault(downloaderName, downloaderName));
                });
                Dao trafficJournalDao = DaoManager.createDao((ConnectionSource)this.getDataSource(), TrafficJournalEntity.class);
                this.recordBatchUpdate("DownloaderName Converting (TrafficJournal)", trafficJournalDao, trafficJournalEntity -> {
                    String downloaderName = trafficJournalEntity.getDownloader();
                    trafficJournalEntity.setDownloader(ConfigTransfer.downloaderNameToUUID.getOrDefault(downloaderName, downloaderName));
                });
                TableUtils.clearTable((ConnectionSource)this.getDataSource(), BanListEntity.class);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 16;
        }
        if (v == 16) {
            v = 17;
        }
        if (v <= 18) {
            try {
                log.info("Dropping old banlist table and re-creating for IPAddress format change");
                TableUtils.clearTable((ConnectionSource)this.database.getDataSource(), BanListEntity.class);
                TableUtils.createTableIfNotExists((ConnectionSource)this.database.getDataSource(), BanListEntity.class);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 19;
        }
        if (v <= 19) {
            try {
                log.info("Adding port field to peer_records");
                this.database.getDataSource().getReadWriteConnection("peer_records").executeStatement("ALTER TABLE peer_records ADD COLUMN port INT NOT NULL DEFAULT 0", -1);
            }
            catch (Exception err) {
                log.error("Unable to upgrade database schema", (Throwable)err);
            }
            v = 20;
        }
        version.setValue(String.valueOf(v));
        metadata.update((Object)version);
    }

    private <T> void recordBatchUpdate(String processName, Dao<T, ?> dao, Consumer<T> consumer) throws Exception {
        long total = dao.countOf();
        dao.callBatchTasks(() -> {
            long processing = 0L;
            for (Object entity : dao.getWrappedIterable()) {
                try {
                    if (++processing % 10L == 0L || processing == total) {
                        log.info(TextManager.tlUI(Lang.DATABASE_UPGRADING_RECORDS, processName, processing, total));
                    }
                    consumer.accept(entity);
                    dao.createOrUpdate(entity);
                }
                catch (Exception e) {
                    log.error("Unhandled error", (Throwable)e);
                }
            }
            return null;
        });
    }

    public BaseConnectionSource getDataSource() {
        return this.database.getDataSource();
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }
}

